// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentScanResultCollection
    {
        // List database SQL Vulnerability Assessment scan results for scan id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDatabaseSQLVulnerabilityAssessmentScanResultsForScanId()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentListScansResults.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentScanResult_ListByScan" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentScanResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "testsvr";
            string databaseName = "master";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scanId1";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentScanResourceId = SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResource sqlDatabaseSqlVulnerabilityAssessmentScan = client.GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(sqlDatabaseSqlVulnerabilityAssessmentScanResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentScanResultResource
            SqlDatabaseSqlVulnerabilityAssessmentScanResultCollection collection = sqlDatabaseSqlVulnerabilityAssessmentScan.GetSqlDatabaseSqlVulnerabilityAssessmentScanResults();

            // invoke the operation and iterate over the result
            await foreach (SqlDatabaseSqlVulnerabilityAssessmentScanResultResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanResultData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a database SQL Vulnerability Assessment scan result for scan id and scan result id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADatabaseSQLVulnerabilityAssessmentScanResultForScanIdAndScanResultId()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScansResults.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentScanResult_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentScanResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            string databaseName = "master";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scanId1";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentScanResourceId = SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResource sqlDatabaseSqlVulnerabilityAssessmentScan = client.GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(sqlDatabaseSqlVulnerabilityAssessmentScanResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentScanResultResource
            SqlDatabaseSqlVulnerabilityAssessmentScanResultCollection collection = sqlDatabaseSqlVulnerabilityAssessmentScan.GetSqlDatabaseSqlVulnerabilityAssessmentScanResults();

            // invoke the operation
            string scanResultId = "VA1234";
            SqlDatabaseSqlVulnerabilityAssessmentScanResultResource result = await collection.GetAsync(scanResultId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanResultData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a database SQL Vulnerability Assessment scan result for scan id and scan result id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetADatabaseSQLVulnerabilityAssessmentScanResultForScanIdAndScanResultId()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScansResults.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentScanResult_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentScanResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            string databaseName = "master";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scanId1";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentScanResourceId = SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResource sqlDatabaseSqlVulnerabilityAssessmentScan = client.GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(sqlDatabaseSqlVulnerabilityAssessmentScanResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentScanResultResource
            SqlDatabaseSqlVulnerabilityAssessmentScanResultCollection collection = sqlDatabaseSqlVulnerabilityAssessmentScan.GetSqlDatabaseSqlVulnerabilityAssessmentScanResults();

            // invoke the operation
            string scanResultId = "VA1234";
            bool result = await collection.ExistsAsync(scanResultId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a database SQL Vulnerability Assessment scan result for scan id and scan result id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetADatabaseSQLVulnerabilityAssessmentScanResultForScanIdAndScanResultId()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScansResults.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentScanResult_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentScanResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            string databaseName = "master";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scanId1";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentScanResourceId = SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResource sqlDatabaseSqlVulnerabilityAssessmentScan = client.GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(sqlDatabaseSqlVulnerabilityAssessmentScanResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentScanResultResource
            SqlDatabaseSqlVulnerabilityAssessmentScanResultCollection collection = sqlDatabaseSqlVulnerabilityAssessmentScan.GetSqlDatabaseSqlVulnerabilityAssessmentScanResults();

            // invoke the operation
            string scanResultId = "VA1234";
            NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentScanResultResource> response = await collection.GetIfExistsAsync(scanResultId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResultResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanResultData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
