// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentScanResource
    {
        // Get a database's vulnerability assessment scan.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADatabaseSVulnerabilityAssessmentScan()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScan.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentScanResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scan001";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentScanResourceId = SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId);
            SqlDatabaseSqlVulnerabilityAssessmentScanResource sqlDatabaseSqlVulnerabilityAssessmentScan = client.GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(sqlDatabaseSqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            SqlDatabaseSqlVulnerabilityAssessmentScanResource result = await sqlDatabaseSqlVulnerabilityAssessmentScan.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
