// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentResource
    {
        // Executes a database's vulnerability assessment scan.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ExecuteScan_ExecutesADatabaseSVulnerabilityAssessmentScan()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentScansExecute.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentExecuteScan_Execute" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentResourceId = SqlDatabaseSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName);
            SqlDatabaseSqlVulnerabilityAssessmentResource sqlDatabaseSqlVulnerabilityAssessment = client.GetSqlDatabaseSqlVulnerabilityAssessmentResource(sqlDatabaseSqlVulnerabilityAssessmentResourceId);

            // invoke the operation
            await sqlDatabaseSqlVulnerabilityAssessment.ExecuteScanAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get SQL Vulnerability Assessment policy for database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSQLVulnerabilityAssessmentPolicyForDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentResourceId = SqlDatabaseSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName);
            SqlDatabaseSqlVulnerabilityAssessmentResource sqlDatabaseSqlVulnerabilityAssessment = client.GetSqlDatabaseSqlVulnerabilityAssessmentResource(sqlDatabaseSqlVulnerabilityAssessmentResourceId);

            // invoke the operation
            SqlDatabaseSqlVulnerabilityAssessmentResource result = await sqlDatabaseSqlVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
