// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentCollection
    {
        // Get SQL Vulnerability Assessment policies on a given database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetSQLVulnerabilityAssessmentPoliciesOnAGivenDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentListByDatabase.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentsSettings_ListByDatabase" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseResource created on azure
            // for more information of creating SqlDatabaseResource, please refer to the document of SqlDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            ResourceIdentifier sqlDatabaseResourceId = SqlDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseResource sqlDatabase = client.GetSqlDatabaseResource(sqlDatabaseResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentResource
            SqlDatabaseSqlVulnerabilityAssessmentCollection collection = sqlDatabase.GetSqlDatabaseSqlVulnerabilityAssessments();

            // invoke the operation and iterate over the result
            await foreach (SqlDatabaseSqlVulnerabilityAssessmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get SQL Vulnerability Assessment policy for database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSQLVulnerabilityAssessmentPolicyForDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseResource created on azure
            // for more information of creating SqlDatabaseResource, please refer to the document of SqlDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            ResourceIdentifier sqlDatabaseResourceId = SqlDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseResource sqlDatabase = client.GetSqlDatabaseResource(sqlDatabaseResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentResource
            SqlDatabaseSqlVulnerabilityAssessmentCollection collection = sqlDatabase.GetSqlDatabaseSqlVulnerabilityAssessments();

            // invoke the operation
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlDatabaseSqlVulnerabilityAssessmentResource result = await collection.GetAsync(vulnerabilityAssessmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get SQL Vulnerability Assessment policy for database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSQLVulnerabilityAssessmentPolicyForDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseResource created on azure
            // for more information of creating SqlDatabaseResource, please refer to the document of SqlDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            ResourceIdentifier sqlDatabaseResourceId = SqlDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseResource sqlDatabase = client.GetSqlDatabaseResource(sqlDatabaseResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentResource
            SqlDatabaseSqlVulnerabilityAssessmentCollection collection = sqlDatabase.GetSqlDatabaseSqlVulnerabilityAssessments();

            // invoke the operation
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            bool result = await collection.ExistsAsync(vulnerabilityAssessmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get SQL Vulnerability Assessment policy for database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSQLVulnerabilityAssessmentPolicyForDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseResource created on azure
            // for more information of creating SqlDatabaseResource, please refer to the document of SqlDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            ResourceIdentifier sqlDatabaseResourceId = SqlDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseResource sqlDatabase = client.GetSqlDatabaseResource(sqlDatabaseResourceId);

            // get the collection of this SqlDatabaseSqlVulnerabilityAssessmentResource
            SqlDatabaseSqlVulnerabilityAssessmentCollection collection = sqlDatabase.GetSqlDatabaseSqlVulnerabilityAssessments();

            // invoke the operation
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentResource> response = await collection.GetIfExistsAsync(vulnerabilityAssessmentName);
            SqlDatabaseSqlVulnerabilityAssessmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
