// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource
    {
        // Gets a database's sql vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseSSqlVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            string ruleId = "VA1001";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource sqlDatabaseSqlVulnerabilityAssessmentBaselineRule = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource result = await sqlDatabaseSqlVulnerabilityAssessmentBaselineRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineCreate.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentRuleBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            string ruleId = "VA1001";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource sqlDatabaseSqlVulnerabilityAssessmentBaselineRule = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                IsLatestScan = false,
                Results =
{
new string[]
{
"userA","SELECT"
},new string[]
{
"userB","SELECT"
},new string[]
{
"userC","SELECT"
}
},
            };
            ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource> lro = await sqlDatabaseSqlVulnerabilityAssessmentBaselineRule.UpdateAsync(WaitUntil.Completed, content);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Removes a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemovesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineDelete.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentRuleBaselines_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            string ruleId = "VA1001";
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource sqlDatabaseSqlVulnerabilityAssessmentBaselineRule = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            await sqlDatabaseSqlVulnerabilityAssessmentBaselineRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
