// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSqlVulnerabilityAssessmentBaselineResource
    {
        // Gets a list of database's sql vulnerability assessment rule baselines.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAListOfDatabaseSSqlVulnerabilityAssessmentRuleBaselines()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineGet.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource sqlDatabaseSqlVulnerabilityAssessmentBaseline = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource result = await sqlDatabaseSqlVulnerabilityAssessmentBaseline.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Add a database's vulnerability assessment rule baseline from the latest scan result.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AddADatabaseSVulnerabilityAssessmentRuleBaselineFromTheLatestScanResult()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineAddLatest.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource sqlDatabaseSqlVulnerabilityAssessmentBaseline = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent()
            {
                IsLatestScan = true,
                Results =
{
},
            };
            ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> lro = await sqlDatabaseSqlVulnerabilityAssessmentBaseline.UpdateAsync(WaitUntil.Completed, content);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Add a database's vulnerability assessment rule baseline list.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AddADatabaseSVulnerabilityAssessmentRuleBaselineList()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineAdd.json
            // this example is just showing the usage of "DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlDatabaseSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlDatabaseSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId = SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource sqlDatabaseSqlVulnerabilityAssessmentBaseline = client.GetSqlDatabaseSqlVulnerabilityAssessmentBaselineResource(sqlDatabaseSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent()
            {
                IsLatestScan = false,
                Results =
{
["VA2063"] = new IList<string>[]
{
new string[]
{
"AllowAll","0.0.0.0","255.255.255.255"
}
},
["VA2065"] = new IList<string>[]
{
new string[]
{
"AllowAll","0.0.0.0","255.255.255.255"
}
},
},
            };
            ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> lro = await sqlDatabaseSqlVulnerabilityAssessmentBaseline.UpdateAsync(WaitUntil.Completed, content);
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
