// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseSensitivityLabelResource
    {
        // Gets the sensitivity label of a given column
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheSensitivityLabelOfAGivenColumn()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ColumnSensitivityLabelGet.json
            // this example is just showing the usage of "SensitivityLabels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSensitivityLabelResource created on azure
            // for more information of creating SqlDatabaseSensitivityLabelResource, please refer to the document of SqlDatabaseSensitivityLabelResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string serverName = "myServer";
            string databaseName = "myDatabase";
            string schemaName = "dbo";
            string tableName = "myTable";
            string columnName = "myColumn";
            SensitivityLabelSource sensitivityLabelSource = SensitivityLabelSource.Current;
            ResourceIdentifier sqlDatabaseSensitivityLabelResourceId = SqlDatabaseSensitivityLabelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource);
            SqlDatabaseSensitivityLabelResource sqlDatabaseSensitivityLabel = client.GetSqlDatabaseSensitivityLabelResource(sqlDatabaseSensitivityLabelResourceId);

            // invoke the operation
            SqlDatabaseSensitivityLabelResource result = await sqlDatabaseSensitivityLabel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SensitivityLabelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
