// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseAutomaticTuningResource
    {
        // Get a database's automatic tuning settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADatabaseSAutomaticTuningSettings()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseAutomaticTuningGet.json
            // this example is just showing the usage of "DatabaseAutomaticTuning_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseAutomaticTuningResource created on azure
            // for more information of creating SqlDatabaseAutomaticTuningResource, please refer to the document of SqlDatabaseAutomaticTuningResource
            string subscriptionId = "c3aa9078-0000-0000-0000-e36f151182d7";
            string resourceGroupName = "default-sql-onebox";
            string serverName = "testsvr11";
            string databaseName = "db1";
            ResourceIdentifier sqlDatabaseAutomaticTuningResourceId = SqlDatabaseAutomaticTuningResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseAutomaticTuningResource sqlDatabaseAutomaticTuning = client.GetSqlDatabaseAutomaticTuningResource(sqlDatabaseAutomaticTuningResourceId);

            // invoke the operation
            SqlDatabaseAutomaticTuningResource result = await sqlDatabaseAutomaticTuning.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlDatabaseAutomaticTuningData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates database automatic tuning settings with all properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesDatabaseAutomaticTuningSettingsWithAllProperties()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseAutomaticTuningUpdateMax.json
            // this example is just showing the usage of "DatabaseAutomaticTuning_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseAutomaticTuningResource created on azure
            // for more information of creating SqlDatabaseAutomaticTuningResource, please refer to the document of SqlDatabaseAutomaticTuningResource
            string subscriptionId = "c3aa9078-0000-0000-0000-e36f151182d7";
            string resourceGroupName = "default-sql-onebox";
            string serverName = "testsvr11";
            string databaseName = "db1";
            ResourceIdentifier sqlDatabaseAutomaticTuningResourceId = SqlDatabaseAutomaticTuningResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseAutomaticTuningResource sqlDatabaseAutomaticTuning = client.GetSqlDatabaseAutomaticTuningResource(sqlDatabaseAutomaticTuningResourceId);

            // invoke the operation
            SqlDatabaseAutomaticTuningData data = new SqlDatabaseAutomaticTuningData()
            {
                DesiredState = AutomaticTuningMode.Auto,
                Options =
{
["createIndex"] = new AutomaticTuningOptions()
{
DesiredState = AutomaticTuningOptionModeDesired.Off,
},
["dropIndex"] = new AutomaticTuningOptions()
{
DesiredState = AutomaticTuningOptionModeDesired.On,
},
["forceLastGoodPlan"] = new AutomaticTuningOptions()
{
DesiredState = AutomaticTuningOptionModeDesired.Default,
},
},
            };
            SqlDatabaseAutomaticTuningResource result = await sqlDatabaseAutomaticTuning.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlDatabaseAutomaticTuningData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates database automatic tuning settings with minimal properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesDatabaseAutomaticTuningSettingsWithMinimalProperties()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseAutomaticTuningUpdateMin.json
            // this example is just showing the usage of "DatabaseAutomaticTuning_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseAutomaticTuningResource created on azure
            // for more information of creating SqlDatabaseAutomaticTuningResource, please refer to the document of SqlDatabaseAutomaticTuningResource
            string subscriptionId = "c3aa9078-0000-0000-0000-e36f151182d7";
            string resourceGroupName = "default-sql-onebox";
            string serverName = "testsvr11";
            string databaseName = "db1";
            ResourceIdentifier sqlDatabaseAutomaticTuningResourceId = SqlDatabaseAutomaticTuningResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            SqlDatabaseAutomaticTuningResource sqlDatabaseAutomaticTuning = client.GetSqlDatabaseAutomaticTuningResource(sqlDatabaseAutomaticTuningResourceId);

            // invoke the operation
            SqlDatabaseAutomaticTuningData data = new SqlDatabaseAutomaticTuningData()
            {
                DesiredState = AutomaticTuningMode.Auto,
            };
            SqlDatabaseAutomaticTuningResource result = await sqlDatabaseAutomaticTuning.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlDatabaseAutomaticTuningData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
