// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlAgentConfigurationResource
    {
        // Gets current instance sql agent configuration.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsCurrentInstanceSqlAgentConfiguration()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SqlAgentConfigurationGet.json
            // this example is just showing the usage of "SqlAgent_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlAgentConfigurationResource created on azure
            // for more information of creating SqlAgentConfigurationResource, please refer to the document of SqlAgentConfigurationResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            ResourceIdentifier sqlAgentConfigurationResourceId = SqlAgentConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName);
            SqlAgentConfigurationResource sqlAgentConfiguration = client.GetSqlAgentConfigurationResource(sqlAgentConfigurationResourceId);

            // invoke the operation
            SqlAgentConfigurationResource result = await sqlAgentConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlAgentConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Puts new sql agent configuration to instance.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PutsNewSqlAgentConfigurationToInstance()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SqlAgentConfigurationPut.json
            // this example is just showing the usage of "SqlAgent_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlAgentConfigurationResource created on azure
            // for more information of creating SqlAgentConfigurationResource, please refer to the document of SqlAgentConfigurationResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            ResourceIdentifier sqlAgentConfigurationResourceId = SqlAgentConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName);
            SqlAgentConfigurationResource sqlAgentConfiguration = client.GetSqlAgentConfigurationResource(sqlAgentConfigurationResourceId);

            // invoke the operation
            SqlAgentConfigurationData data = new SqlAgentConfigurationData()
            {
                State = SqlAgentConfigurationPropertiesState.Enabled,
            };
            ArmOperation<SqlAgentConfigurationResource> lro = await sqlAgentConfiguration.CreateOrUpdateAsync(WaitUntil.Completed, data);
            SqlAgentConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlAgentConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
