// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_RestorableDroppedDatabaseResource
    {
        // Gets a restorable dropped database with expand equals keys.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsARestorableDroppedDatabaseWithExpandEqualsKeys()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/GetRestorableDroppedDatabaseWithExpandEqualsKeys.json
            // this example is just showing the usage of "RestorableDroppedDatabases_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RestorableDroppedDatabaseResource created on azure
            // for more information of creating RestorableDroppedDatabaseResource, please refer to the document of RestorableDroppedDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string restorableDroppedDatabaseId = "testdb,131403269876900000";
            ResourceIdentifier restorableDroppedDatabaseResourceId = RestorableDroppedDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, restorableDroppedDatabaseId);
            RestorableDroppedDatabaseResource restorableDroppedDatabase = client.GetRestorableDroppedDatabaseResource(restorableDroppedDatabaseResourceId);

            // invoke the operation
            string expand = "keys";
            RestorableDroppedDatabaseResource result = await restorableDroppedDatabase.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RestorableDroppedDatabaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a restorable dropped database.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsARestorableDroppedDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/GetRestorableDroppedDatabase.json
            // this example is just showing the usage of "RestorableDroppedDatabases_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RestorableDroppedDatabaseResource created on azure
            // for more information of creating RestorableDroppedDatabaseResource, please refer to the document of RestorableDroppedDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string restorableDroppedDatabaseId = "testdb,131403269876900000";
            ResourceIdentifier restorableDroppedDatabaseResourceId = RestorableDroppedDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, restorableDroppedDatabaseId);
            RestorableDroppedDatabaseResource restorableDroppedDatabase = client.GetRestorableDroppedDatabaseResource(restorableDroppedDatabaseResourceId);

            // invoke the operation
            RestorableDroppedDatabaseResource result = await restorableDroppedDatabase.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RestorableDroppedDatabaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
