// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_RecoverableManagedDatabaseResource
    {
        // Gets a recoverable databases by managed instances
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsARecoverableDatabasesByManagedInstances()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetRecoverableManagedDatabase.json
            // this example is just showing the usage of "RecoverableManagedDatabases_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RecoverableManagedDatabaseResource created on azure
            // for more information of creating RecoverableManagedDatabaseResource, please refer to the document of RecoverableManagedDatabaseResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Test1";
            string managedInstanceName = "managedInstance";
            string recoverableDatabaseName = "testdb";
            ResourceIdentifier recoverableManagedDatabaseResourceId = RecoverableManagedDatabaseResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, recoverableDatabaseName);
            RecoverableManagedDatabaseResource recoverableManagedDatabase = client.GetRecoverableManagedDatabaseResource(recoverableManagedDatabaseResourceId);

            // invoke the operation
            RecoverableManagedDatabaseResource result = await recoverableManagedDatabase.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RecoverableManagedDatabaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
