// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedTransparentDataEncryptionResource
    {
        // Get a database's transparent data encryption
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADatabaseSTransparentDataEncryption()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedTransparentDataEncryptionGet.json
            // this example is just showing the usage of "ManagedDatabaseTransparentDataEncryption_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedTransparentDataEncryptionResource created on azure
            // for more information of creating ManagedTransparentDataEncryptionResource, please refer to the document of ManagedTransparentDataEncryptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "security-tde-resourcegroup";
            string managedInstanceName = "securitytde";
            string databaseName = "testdb";
            TransparentDataEncryptionName tdeName = TransparentDataEncryptionName.Current;
            ResourceIdentifier managedTransparentDataEncryptionResourceId = ManagedTransparentDataEncryptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, tdeName);
            ManagedTransparentDataEncryptionResource managedTransparentDataEncryption = client.GetManagedTransparentDataEncryptionResource(managedTransparentDataEncryptionResourceId);

            // invoke the operation
            ManagedTransparentDataEncryptionResource result = await managedTransparentDataEncryption.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedTransparentDataEncryptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a database's Transparent Data Encryption state with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateADatabaseSTransparentDataEncryptionStateWithMinimalParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedTransparentDataEncryptionUpdate.json
            // this example is just showing the usage of "ManagedDatabaseTransparentDataEncryption_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedTransparentDataEncryptionResource created on azure
            // for more information of creating ManagedTransparentDataEncryptionResource, please refer to the document of ManagedTransparentDataEncryptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securitytde-42-rg";
            string managedInstanceName = "securitytde-42";
            string databaseName = "testdb";
            TransparentDataEncryptionName tdeName = TransparentDataEncryptionName.Current;
            ResourceIdentifier managedTransparentDataEncryptionResourceId = ManagedTransparentDataEncryptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, tdeName);
            ManagedTransparentDataEncryptionResource managedTransparentDataEncryption = client.GetManagedTransparentDataEncryptionResource(managedTransparentDataEncryptionResourceId);

            // invoke the operation
            ManagedTransparentDataEncryptionData data = new ManagedTransparentDataEncryptionData()
            {
                State = TransparentDataEncryptionState.Enabled,
            };
            ArmOperation<ManagedTransparentDataEncryptionResource> lro = await managedTransparentDataEncryption.UpdateAsync(WaitUntil.Completed, data);
            ManagedTransparentDataEncryptionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedTransparentDataEncryptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
