// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedServerSecurityAlertPolicyResource
    {
        // Get a managed server's threat detection policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAManagedServerSThreatDetectionPolicy()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedServerSecurityAlertGet.json
            // this example is just showing the usage of "ManagedServerSecurityAlertPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerSecurityAlertPolicyResource created on azure
            // for more information of creating ManagedServerSecurityAlertPolicyResource, please refer to the document of ManagedServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string managedInstanceName = "securityalert-6440";
            SqlSecurityAlertPolicyName securityAlertPolicyName = SqlSecurityAlertPolicyName.Default;
            ResourceIdentifier managedServerSecurityAlertPolicyResourceId = ManagedServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, securityAlertPolicyName);
            ManagedServerSecurityAlertPolicyResource managedServerSecurityAlertPolicy = client.GetManagedServerSecurityAlertPolicyResource(managedServerSecurityAlertPolicyResourceId);

            // invoke the operation
            ManagedServerSecurityAlertPolicyResource result = await managedServerSecurityAlertPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a managed server's threat detection policy with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAManagedServerSThreatDetectionPolicyWithAllParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedServerSecurityAlertCreateMax.json
            // this example is just showing the usage of "ManagedServerSecurityAlertPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerSecurityAlertPolicyResource created on azure
            // for more information of creating ManagedServerSecurityAlertPolicyResource, please refer to the document of ManagedServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string managedInstanceName = "securityalert-6440";
            SqlSecurityAlertPolicyName securityAlertPolicyName = SqlSecurityAlertPolicyName.Default;
            ResourceIdentifier managedServerSecurityAlertPolicyResourceId = ManagedServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, securityAlertPolicyName);
            ManagedServerSecurityAlertPolicyResource managedServerSecurityAlertPolicy = client.GetManagedServerSecurityAlertPolicyResource(managedServerSecurityAlertPolicyResourceId);

            // invoke the operation
            ManagedServerSecurityAlertPolicyData data = new ManagedServerSecurityAlertPolicyData()
            {
                State = SecurityAlertsPolicyState.Enabled,
                DisabledAlerts =
{
"Access_Anomaly","Usage_Anomaly"
},
                EmailAddresses =
{
"testSecurityAlert@microsoft.com"
},
                SendToEmailAccountAdmins = true,
                StorageEndpoint = "https://mystorage.blob.core.windows.net",
                StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
                RetentionDays = 5,
            };
            ArmOperation<ManagedServerSecurityAlertPolicyResource> lro = await managedServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            ManagedServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a managed server's threat detection policy with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAManagedServerSThreatDetectionPolicyWithMinimalParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedServerSecurityAlertCreateMin.json
            // this example is just showing the usage of "ManagedServerSecurityAlertPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerSecurityAlertPolicyResource created on azure
            // for more information of creating ManagedServerSecurityAlertPolicyResource, please refer to the document of ManagedServerSecurityAlertPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "securityalert-4799";
            string managedInstanceName = "securityalert-6440";
            SqlSecurityAlertPolicyName securityAlertPolicyName = SqlSecurityAlertPolicyName.Default;
            ResourceIdentifier managedServerSecurityAlertPolicyResourceId = ManagedServerSecurityAlertPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, securityAlertPolicyName);
            ManagedServerSecurityAlertPolicyResource managedServerSecurityAlertPolicy = client.GetManagedServerSecurityAlertPolicyResource(managedServerSecurityAlertPolicyResourceId);

            // invoke the operation
            ManagedServerSecurityAlertPolicyData data = new ManagedServerSecurityAlertPolicyData()
            {
                State = SecurityAlertsPolicyState.Enabled,
            };
            ArmOperation<ManagedServerSecurityAlertPolicyResource> lro = await managedServerSecurityAlertPolicy.UpdateAsync(WaitUntil.Completed, data);
            ManagedServerSecurityAlertPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerSecurityAlertPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
