// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedServerDnsAliasResource
    {
        // Get managed server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetManagedServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-11-01-preview/examples/ManagedServerDnsAliasGet.json
            // this example is just showing the usage of "ManagedServerDnsAliases_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerDnsAliasResource created on azure
            // for more information of creating ManagedServerDnsAliasResource, please refer to the document of ManagedServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string managedInstanceName = "dns-mi";
            string dnsAliasName = "dns-alias-mi";
            ResourceIdentifier managedServerDnsAliasResourceId = ManagedServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dnsAliasName);
            ManagedServerDnsAliasResource managedServerDnsAlias = client.GetManagedServerDnsAliasResource(managedServerDnsAliasResourceId);

            // invoke the operation
            ManagedServerDnsAliasResource result = await managedServerDnsAlias.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create managed server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateManagedServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-11-01-preview/examples/ManagedServerDnsAliasCreateOrUpdate.json
            // this example is just showing the usage of "ManagedServerDnsAliases_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerDnsAliasResource created on azure
            // for more information of creating ManagedServerDnsAliasResource, please refer to the document of ManagedServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string managedInstanceName = "dns-mi";
            string dnsAliasName = "dns-alias-mi";
            ResourceIdentifier managedServerDnsAliasResourceId = ManagedServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dnsAliasName);
            ManagedServerDnsAliasResource managedServerDnsAlias = client.GetManagedServerDnsAliasResource(managedServerDnsAliasResourceId);

            // invoke the operation
            ManagedServerDnsAliasCreateOrUpdateContent content = new ManagedServerDnsAliasCreateOrUpdateContent();
            ArmOperation<ManagedServerDnsAliasResource> lro = await managedServerDnsAlias.UpdateAsync(WaitUntil.Completed, content);
            ManagedServerDnsAliasResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete managed server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteManagedServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-11-01-preview/examples/ManagedServerDnsAliasDelete.json
            // this example is just showing the usage of "ManagedServerDnsAliases_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerDnsAliasResource created on azure
            // for more information of creating ManagedServerDnsAliasResource, please refer to the document of ManagedServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string managedInstanceName = "dns-mi";
            string dnsAliasName = "dns-alias-mi";
            ResourceIdentifier managedServerDnsAliasResourceId = ManagedServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dnsAliasName);
            ManagedServerDnsAliasResource managedServerDnsAlias = client.GetManagedServerDnsAliasResource(managedServerDnsAliasResourceId);

            // invoke the operation
            await managedServerDnsAlias.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Acquire managed server DNS alias.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Acquire_AcquireManagedServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-11-01-preview/examples/ManagedServerDnsAliasAcquire.json
            // this example is just showing the usage of "ManagedServerDnsAliases_Acquire" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedServerDnsAliasResource created on azure
            // for more information of creating ManagedServerDnsAliasResource, please refer to the document of ManagedServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string managedInstanceName = "new-mi";
            string dnsAliasName = "dns-alias-mi";
            ResourceIdentifier managedServerDnsAliasResourceId = ManagedServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dnsAliasName);
            ManagedServerDnsAliasResource managedServerDnsAlias = client.GetManagedServerDnsAliasResource(managedServerDnsAliasResourceId);

            // invoke the operation
            ManagedServerDnsAliasAcquisition managedServerDnsAliasAcquisition = new ManagedServerDnsAliasAcquisition(new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/old-mi/dnsAliases/alias1"));
            ArmOperation<ManagedServerDnsAliasResource> lro = await managedServerDnsAlias.AcquireAsync(WaitUntil.Completed, managedServerDnsAliasAcquisition);
            ManagedServerDnsAliasResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
