// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceVulnerabilityAssessmentResource
    {
        // Get a managed instance's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAManagedInstanceSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "ManagedInstanceVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedInstanceVulnerabilityAssessmentResource, please refer to the document of ManagedInstanceVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedInstanceVulnerabilityAssessmentResourceId = ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName);
            ManagedInstanceVulnerabilityAssessmentResource managedInstanceVulnerabilityAssessment = client.GetManagedInstanceVulnerabilityAssessmentResource(managedInstanceVulnerabilityAssessmentResourceId);

            // invoke the operation
            ManagedInstanceVulnerabilityAssessmentResource result = await managedInstanceVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a managed instance's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAManagedInstanceSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceVulnerabilityAssessmentCreateMax.json
            // this example is just showing the usage of "ManagedInstanceVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedInstanceVulnerabilityAssessmentResource, please refer to the document of ManagedInstanceVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedInstanceVulnerabilityAssessmentResourceId = ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName);
            ManagedInstanceVulnerabilityAssessmentResource managedInstanceVulnerabilityAssessment = client.GetManagedInstanceVulnerabilityAssessmentResource(managedInstanceVulnerabilityAssessmentResourceId);

            // invoke the operation
            ManagedInstanceVulnerabilityAssessmentData data = new ManagedInstanceVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new VulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EmailSubscriptionAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<ManagedInstanceVulnerabilityAssessmentResource> lro = await managedInstanceVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a managed instance's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAManagedInstanceSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceVulnerabilityAssessmentCreateStorageAccessKeyMin.json
            // this example is just showing the usage of "ManagedInstanceVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedInstanceVulnerabilityAssessmentResource, please refer to the document of ManagedInstanceVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedInstanceVulnerabilityAssessmentResourceId = ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName);
            ManagedInstanceVulnerabilityAssessmentResource managedInstanceVulnerabilityAssessment = client.GetManagedInstanceVulnerabilityAssessmentResource(managedInstanceVulnerabilityAssessmentResourceId);

            // invoke the operation
            ManagedInstanceVulnerabilityAssessmentData data = new ManagedInstanceVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<ManagedInstanceVulnerabilityAssessmentResource> lro = await managedInstanceVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a managed instance's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAManagedInstanceSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceVulnerabilityAssessmentCreateContainerSasKeyMin.json
            // this example is just showing the usage of "ManagedInstanceVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedInstanceVulnerabilityAssessmentResource, please refer to the document of ManagedInstanceVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedInstanceVulnerabilityAssessmentResourceId = ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName);
            ManagedInstanceVulnerabilityAssessmentResource managedInstanceVulnerabilityAssessment = client.GetManagedInstanceVulnerabilityAssessmentResource(managedInstanceVulnerabilityAssessmentResourceId);

            // invoke the operation
            ManagedInstanceVulnerabilityAssessmentData data = new ManagedInstanceVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<ManagedInstanceVulnerabilityAssessmentResource> lro = await managedInstanceVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Remove a managed instance's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemoveAManagedInstanceSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceVulnerabilityAssessmentDelete.json
            // this example is just showing the usage of "ManagedInstanceVulnerabilityAssessments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedInstanceVulnerabilityAssessmentResource, please refer to the document of ManagedInstanceVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedInstanceVulnerabilityAssessmentResourceId = ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName);
            ManagedInstanceVulnerabilityAssessmentResource managedInstanceVulnerabilityAssessment = client.GetManagedInstanceVulnerabilityAssessmentResource(managedInstanceVulnerabilityAssessmentResourceId);

            // invoke the operation
            await managedInstanceVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
