// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceServerConfigurationOptionResource
    {
        // Gets managed instance server configuration option.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsManagedInstanceServerConfigurationOption()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ServerConfigurationOptionGet.json
            // this example is just showing the usage of "ServerConfigurationOptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceServerConfigurationOptionResource created on azure
            // for more information of creating ManagedInstanceServerConfigurationOptionResource, please refer to the document of ManagedInstanceServerConfigurationOptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string managedInstanceName = "testinstance";
            ManagedInstanceServerConfigurationOptionName serverConfigurationOptionName = ManagedInstanceServerConfigurationOptionName.AllowPolybaseExport;
            ResourceIdentifier managedInstanceServerConfigurationOptionResourceId = ManagedInstanceServerConfigurationOptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, serverConfigurationOptionName);
            ManagedInstanceServerConfigurationOptionResource managedInstanceServerConfigurationOption = client.GetManagedInstanceServerConfigurationOptionResource(managedInstanceServerConfigurationOptionResourceId);

            // invoke the operation
            ManagedInstanceServerConfigurationOptionResource result = await managedInstanceServerConfigurationOption.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceServerConfigurationOptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates managed instance server configuration option.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesManagedInstanceServerConfigurationOption()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-08-01-preview/examples/ServerConfigurationOptionUpdate.json
            // this example is just showing the usage of "ServerConfigurationOptions_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceServerConfigurationOptionResource created on azure
            // for more information of creating ManagedInstanceServerConfigurationOptionResource, please refer to the document of ManagedInstanceServerConfigurationOptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string managedInstanceName = "testinstance";
            ManagedInstanceServerConfigurationOptionName serverConfigurationOptionName = ManagedInstanceServerConfigurationOptionName.AllowPolybaseExport;
            ResourceIdentifier managedInstanceServerConfigurationOptionResourceId = ManagedInstanceServerConfigurationOptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, serverConfigurationOptionName);
            ManagedInstanceServerConfigurationOptionResource managedInstanceServerConfigurationOption = client.GetManagedInstanceServerConfigurationOptionResource(managedInstanceServerConfigurationOptionResourceId);

            // invoke the operation
            ManagedInstanceServerConfigurationOptionData data = new ManagedInstanceServerConfigurationOptionData()
            {
                ServerConfigurationOptionValue = 1,
            };
            ArmOperation<ManagedInstanceServerConfigurationOptionResource> lro = await managedInstanceServerConfigurationOption.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceServerConfigurationOptionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceServerConfigurationOptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
