// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceEncryptionProtectorResource
    {
        // Revalidates the encryption protector
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Revalidate_RevalidatesTheEncryptionProtector()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceEncryptionProtectorRevalidate.json
            // this example is just showing the usage of "ManagedInstanceEncryptionProtectors_Revalidate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceEncryptionProtectorResource created on azure
            // for more information of creating ManagedInstanceEncryptionProtectorResource, please refer to the document of ManagedInstanceEncryptionProtectorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            EncryptionProtectorName encryptionProtectorName = EncryptionProtectorName.Current;
            ResourceIdentifier managedInstanceEncryptionProtectorResourceId = ManagedInstanceEncryptionProtectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, encryptionProtectorName);
            ManagedInstanceEncryptionProtectorResource managedInstanceEncryptionProtector = client.GetManagedInstanceEncryptionProtectorResource(managedInstanceEncryptionProtectorResourceId);

            // invoke the operation
            await managedInstanceEncryptionProtector.RevalidateAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get the encryption protector
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheEncryptionProtector()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceEncryptionProtectorGet.json
            // this example is just showing the usage of "ManagedInstanceEncryptionProtectors_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceEncryptionProtectorResource created on azure
            // for more information of creating ManagedInstanceEncryptionProtectorResource, please refer to the document of ManagedInstanceEncryptionProtectorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            EncryptionProtectorName encryptionProtectorName = EncryptionProtectorName.Current;
            ResourceIdentifier managedInstanceEncryptionProtectorResourceId = ManagedInstanceEncryptionProtectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, encryptionProtectorName);
            ManagedInstanceEncryptionProtectorResource managedInstanceEncryptionProtector = client.GetManagedInstanceEncryptionProtectorResource(managedInstanceEncryptionProtectorResourceId);

            // invoke the operation
            ManagedInstanceEncryptionProtectorResource result = await managedInstanceEncryptionProtector.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceEncryptionProtectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update the encryption protector to key vault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateTheEncryptionProtectorToKeyVault()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceEncryptionProtectorCreateOrUpdateKeyVault.json
            // this example is just showing the usage of "ManagedInstanceEncryptionProtectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceEncryptionProtectorResource created on azure
            // for more information of creating ManagedInstanceEncryptionProtectorResource, please refer to the document of ManagedInstanceEncryptionProtectorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            EncryptionProtectorName encryptionProtectorName = EncryptionProtectorName.Current;
            ResourceIdentifier managedInstanceEncryptionProtectorResourceId = ManagedInstanceEncryptionProtectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, encryptionProtectorName);
            ManagedInstanceEncryptionProtectorResource managedInstanceEncryptionProtector = client.GetManagedInstanceEncryptionProtectorResource(managedInstanceEncryptionProtectorResourceId);

            // invoke the operation
            ManagedInstanceEncryptionProtectorData data = new ManagedInstanceEncryptionProtectorData()
            {
                ServerKeyName = "someVault_someKey_01234567890123456789012345678901",
                ServerKeyType = SqlServerKeyType.AzureKeyVault,
                IsAutoRotationEnabled = false,
            };
            ArmOperation<ManagedInstanceEncryptionProtectorResource> lro = await managedInstanceEncryptionProtector.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceEncryptionProtectorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceEncryptionProtectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update the encryption protector to service managed
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateTheEncryptionProtectorToServiceManaged()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceEncryptionProtectorCreateOrUpdateServiceManaged.json
            // this example is just showing the usage of "ManagedInstanceEncryptionProtectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceEncryptionProtectorResource created on azure
            // for more information of creating ManagedInstanceEncryptionProtectorResource, please refer to the document of ManagedInstanceEncryptionProtectorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string managedInstanceName = "sqlcrudtest-4645";
            EncryptionProtectorName encryptionProtectorName = EncryptionProtectorName.Current;
            ResourceIdentifier managedInstanceEncryptionProtectorResourceId = ManagedInstanceEncryptionProtectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, encryptionProtectorName);
            ManagedInstanceEncryptionProtectorResource managedInstanceEncryptionProtector = client.GetManagedInstanceEncryptionProtectorResource(managedInstanceEncryptionProtectorResourceId);

            // invoke the operation
            ManagedInstanceEncryptionProtectorData data = new ManagedInstanceEncryptionProtectorData()
            {
                ServerKeyName = "ServiceManaged",
                ServerKeyType = SqlServerKeyType.ServiceManaged,
            };
            ArmOperation<ManagedInstanceEncryptionProtectorResource> lro = await managedInstanceEncryptionProtector.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceEncryptionProtectorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceEncryptionProtectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
