// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceDtcResource
    {
        // Gets managed instance DTC settings.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsManagedInstanceDTCSettings()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedInstanceDtcGet.json
            // this example is just showing the usage of "ManagedInstanceDtcs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceDtcResource created on azure
            // for more information of creating ManagedInstanceDtcResource, please refer to the document of ManagedInstanceDtcResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string managedInstanceName = "testinstance";
            DtcName dtcName = DtcName.Current;
            ResourceIdentifier managedInstanceDtcResourceId = ManagedInstanceDtcResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dtcName);
            ManagedInstanceDtcResource managedInstanceDtc = client.GetManagedInstanceDtcResource(managedInstanceDtcResourceId);

            // invoke the operation
            ManagedInstanceDtcResource result = await managedInstanceDtc.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceDtcData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates managed instance DTC settings by enabling DTC.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesManagedInstanceDTCSettingsByEnablingDTC()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedInstanceDtcUpdateEnableDtc.json
            // this example is just showing the usage of "ManagedInstanceDtcs_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceDtcResource created on azure
            // for more information of creating ManagedInstanceDtcResource, please refer to the document of ManagedInstanceDtcResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string managedInstanceName = "testinstance";
            DtcName dtcName = DtcName.Current;
            ResourceIdentifier managedInstanceDtcResourceId = ManagedInstanceDtcResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dtcName);
            ManagedInstanceDtcResource managedInstanceDtc = client.GetManagedInstanceDtcResource(managedInstanceDtcResourceId);

            // invoke the operation
            ManagedInstanceDtcData data = new ManagedInstanceDtcData()
            {
                DtcEnabled = true,
            };
            ArmOperation<ManagedInstanceDtcResource> lro = await managedInstanceDtc.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceDtcResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceDtcData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates managed instance DTC settings with all optional parameters specified.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesManagedInstanceDTCSettingsWithAllOptionalParametersSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedInstanceDtcUpdateMax.json
            // this example is just showing the usage of "ManagedInstanceDtcs_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceDtcResource created on azure
            // for more information of creating ManagedInstanceDtcResource, please refer to the document of ManagedInstanceDtcResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string managedInstanceName = "testinstance";
            DtcName dtcName = DtcName.Current;
            ResourceIdentifier managedInstanceDtcResourceId = ManagedInstanceDtcResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, dtcName);
            ManagedInstanceDtcResource managedInstanceDtc = client.GetManagedInstanceDtcResource(managedInstanceDtcResourceId);

            // invoke the operation
            ManagedInstanceDtcData data = new ManagedInstanceDtcData()
            {
                DtcEnabled = true,
                SecuritySettings = new ManagedInstanceDtcSecuritySettings()
                {
                    TransactionManagerCommunicationSettings = new ManagedInstanceDtcTransactionManagerCommunicationSettings()
                    {
                        AllowInboundEnabled = false,
                        AllowOutboundEnabled = true,
                        Authentication = "NoAuth",
                    },
                    IsXATransactionsEnabled = false,
                    SnaLu6Point2TransactionsEnabled = false,
                    XATransactionsDefaultTimeoutInSeconds = 1000,
                    XATransactionsMaximumTimeoutInSeconds = 3000,
                },
                ExternalDnsSuffixSearchList =
{
"dns.example1.com","dns.example2.com"
},
            };
            ArmOperation<ManagedInstanceDtcResource> lro = await managedInstanceDtc.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceDtcResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceDtcData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
