// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceAzureADOnlyAuthenticationResource
    {
        // Gets a Azure Active Directory only authentication property.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAAzureActiveDirectoryOnlyAuthenticationProperty()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAzureADOnlyAuthGet.json
            // this example is just showing the usage of "ManagedInstanceAzureADOnlyAuthentications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAzureADOnlyAuthenticationResource created on azure
            // for more information of creating ManagedInstanceAzureADOnlyAuthenticationResource, please refer to the document of ManagedInstanceAzureADOnlyAuthenticationResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            AuthenticationName authenticationName = AuthenticationName.Default;
            ResourceIdentifier managedInstanceAzureADOnlyAuthenticationResourceId = ManagedInstanceAzureADOnlyAuthenticationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, authenticationName);
            ManagedInstanceAzureADOnlyAuthenticationResource managedInstanceAzureADOnlyAuthentication = client.GetManagedInstanceAzureADOnlyAuthenticationResource(managedInstanceAzureADOnlyAuthenticationResourceId);

            // invoke the operation
            ManagedInstanceAzureADOnlyAuthenticationResource result = await managedInstanceAzureADOnlyAuthentication.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAzureADOnlyAuthenticationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates Azure Active Directory only authentication object.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesAzureActiveDirectoryOnlyAuthenticationObject()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAzureADOnlyAuthCreateOrUpdate.json
            // this example is just showing the usage of "ManagedInstanceAzureADOnlyAuthentications_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAzureADOnlyAuthenticationResource created on azure
            // for more information of creating ManagedInstanceAzureADOnlyAuthenticationResource, please refer to the document of ManagedInstanceAzureADOnlyAuthenticationResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            AuthenticationName authenticationName = AuthenticationName.Default;
            ResourceIdentifier managedInstanceAzureADOnlyAuthenticationResourceId = ManagedInstanceAzureADOnlyAuthenticationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, authenticationName);
            ManagedInstanceAzureADOnlyAuthenticationResource managedInstanceAzureADOnlyAuthentication = client.GetManagedInstanceAzureADOnlyAuthenticationResource(managedInstanceAzureADOnlyAuthenticationResourceId);

            // invoke the operation
            ManagedInstanceAzureADOnlyAuthenticationData data = new ManagedInstanceAzureADOnlyAuthenticationData()
            {
                IsAzureADOnlyAuthenticationEnabled = false,
            };
            ArmOperation<ManagedInstanceAzureADOnlyAuthenticationResource> lro = await managedInstanceAzureADOnlyAuthentication.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceAzureADOnlyAuthenticationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAzureADOnlyAuthenticationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes Azure Active Directory only authentication object.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesAzureActiveDirectoryOnlyAuthenticationObject()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAzureADOnlyAuthDelete.json
            // this example is just showing the usage of "ManagedInstanceAzureADOnlyAuthentications_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAzureADOnlyAuthenticationResource created on azure
            // for more information of creating ManagedInstanceAzureADOnlyAuthenticationResource, please refer to the document of ManagedInstanceAzureADOnlyAuthenticationResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            AuthenticationName authenticationName = AuthenticationName.Default;
            ResourceIdentifier managedInstanceAzureADOnlyAuthenticationResourceId = ManagedInstanceAzureADOnlyAuthenticationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, authenticationName);
            ManagedInstanceAzureADOnlyAuthenticationResource managedInstanceAzureADOnlyAuthentication = client.GetManagedInstanceAzureADOnlyAuthenticationResource(managedInstanceAzureADOnlyAuthenticationResourceId);

            // invoke the operation
            await managedInstanceAzureADOnlyAuthentication.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
