// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceAdvancedThreatProtectionResource
    {
        // Get a managed instance's Advanced Threat Protection settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAManagedInstanceSAdvancedThreatProtectionSettings()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-02-01-preview/examples/ManagedInstanceAdvancedThreatProtectionSettingsGet.json
            // this example is just showing the usage of "ManagedInstanceAdvancedThreatProtectionSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdvancedThreatProtectionResource created on azure
            // for more information of creating ManagedInstanceAdvancedThreatProtectionResource, please refer to the document of ManagedInstanceAdvancedThreatProtectionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "threatprotection-4799";
            string managedInstanceName = "threatprotection-6440";
            AdvancedThreatProtectionName advancedThreatProtectionName = AdvancedThreatProtectionName.Default;
            ResourceIdentifier managedInstanceAdvancedThreatProtectionResourceId = ManagedInstanceAdvancedThreatProtectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, advancedThreatProtectionName);
            ManagedInstanceAdvancedThreatProtectionResource managedInstanceAdvancedThreatProtection = client.GetManagedInstanceAdvancedThreatProtectionResource(managedInstanceAdvancedThreatProtectionResourceId);

            // invoke the operation
            ManagedInstanceAdvancedThreatProtectionResource result = await managedInstanceAdvancedThreatProtection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdvancedThreatProtectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a managed instance's Advanced Threat Protection settings with all parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAManagedInstanceSAdvancedThreatProtectionSettingsWithAllParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-02-01-preview/examples/ManagedInstanceAdvancedThreatProtectionSettingsCreateMax.json
            // this example is just showing the usage of "ManagedInstanceAdvancedThreatProtectionSettings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdvancedThreatProtectionResource created on azure
            // for more information of creating ManagedInstanceAdvancedThreatProtectionResource, please refer to the document of ManagedInstanceAdvancedThreatProtectionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "threatprotection-4799";
            string managedInstanceName = "threatprotection-6440";
            AdvancedThreatProtectionName advancedThreatProtectionName = AdvancedThreatProtectionName.Default;
            ResourceIdentifier managedInstanceAdvancedThreatProtectionResourceId = ManagedInstanceAdvancedThreatProtectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, advancedThreatProtectionName);
            ManagedInstanceAdvancedThreatProtectionResource managedInstanceAdvancedThreatProtection = client.GetManagedInstanceAdvancedThreatProtectionResource(managedInstanceAdvancedThreatProtectionResourceId);

            // invoke the operation
            ManagedInstanceAdvancedThreatProtectionData data = new ManagedInstanceAdvancedThreatProtectionData()
            {
                State = AdvancedThreatProtectionState.Enabled,
            };
            ArmOperation<ManagedInstanceAdvancedThreatProtectionResource> lro = await managedInstanceAdvancedThreatProtection.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceAdvancedThreatProtectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdvancedThreatProtectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a managed instance's Advanced Threat Protection settings with minimal parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAManagedInstanceSAdvancedThreatProtectionSettingsWithMinimalParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-02-01-preview/examples/ManagedInstanceAdvancedThreatProtectionSettingsCreateMin.json
            // this example is just showing the usage of "ManagedInstanceAdvancedThreatProtectionSettings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdvancedThreatProtectionResource created on azure
            // for more information of creating ManagedInstanceAdvancedThreatProtectionResource, please refer to the document of ManagedInstanceAdvancedThreatProtectionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "threatprotection-4799";
            string managedInstanceName = "threatprotection-6440";
            AdvancedThreatProtectionName advancedThreatProtectionName = AdvancedThreatProtectionName.Default;
            ResourceIdentifier managedInstanceAdvancedThreatProtectionResourceId = ManagedInstanceAdvancedThreatProtectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, advancedThreatProtectionName);
            ManagedInstanceAdvancedThreatProtectionResource managedInstanceAdvancedThreatProtection = client.GetManagedInstanceAdvancedThreatProtectionResource(managedInstanceAdvancedThreatProtectionResourceId);

            // invoke the operation
            ManagedInstanceAdvancedThreatProtectionData data = new ManagedInstanceAdvancedThreatProtectionData()
            {
                State = AdvancedThreatProtectionState.Disabled,
            };
            ArmOperation<ManagedInstanceAdvancedThreatProtectionResource> lro = await managedInstanceAdvancedThreatProtection.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceAdvancedThreatProtectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdvancedThreatProtectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
