// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedInstanceAdministratorResource
    {
        // Get administrator of managed instance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAdministratorOfManagedInstance()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAdministratorGet.json
            // this example is just showing the usage of "ManagedInstanceAdministrators_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdministratorResource created on azure
            // for more information of creating ManagedInstanceAdministratorResource, please refer to the document of ManagedInstanceAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier managedInstanceAdministratorResourceId = ManagedInstanceAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, administratorName);
            ManagedInstanceAdministratorResource managedInstanceAdministrator = client.GetManagedInstanceAdministratorResource(managedInstanceAdministratorResourceId);

            // invoke the operation
            ManagedInstanceAdministratorResource result = await managedInstanceAdministrator.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdministratorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create administrator of managed instance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAdministratorOfManagedInstance()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAdministratorCreate.json
            // this example is just showing the usage of "ManagedInstanceAdministrators_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdministratorResource created on azure
            // for more information of creating ManagedInstanceAdministratorResource, please refer to the document of ManagedInstanceAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier managedInstanceAdministratorResourceId = ManagedInstanceAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, administratorName);
            ManagedInstanceAdministratorResource managedInstanceAdministrator = client.GetManagedInstanceAdministratorResource(managedInstanceAdministratorResourceId);

            // invoke the operation
            ManagedInstanceAdministratorData data = new ManagedInstanceAdministratorData()
            {
                AdministratorType = ManagedInstanceAdministratorType.ActiveDirectory,
                Login = "bob@contoso.com",
                Sid = Guid.Parse("44444444-3333-2222-1111-000000000000"),
                TenantId = Guid.Parse("55555555-4444-3333-2222-111111111111"),
            };
            ArmOperation<ManagedInstanceAdministratorResource> lro = await managedInstanceAdministrator.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceAdministratorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdministratorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update administrator of managed instance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAdministratorOfManagedInstance()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAdministratorUpdate.json
            // this example is just showing the usage of "ManagedInstanceAdministrators_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdministratorResource created on azure
            // for more information of creating ManagedInstanceAdministratorResource, please refer to the document of ManagedInstanceAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier managedInstanceAdministratorResourceId = ManagedInstanceAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, administratorName);
            ManagedInstanceAdministratorResource managedInstanceAdministrator = client.GetManagedInstanceAdministratorResource(managedInstanceAdministratorResourceId);

            // invoke the operation
            ManagedInstanceAdministratorData data = new ManagedInstanceAdministratorData()
            {
                AdministratorType = ManagedInstanceAdministratorType.ActiveDirectory,
                Login = "bob@contoso.com",
                Sid = Guid.Parse("44444444-3333-2222-1111-000000000000"),
                TenantId = Guid.Parse("55555555-4444-3333-2222-111111111111"),
            };
            ArmOperation<ManagedInstanceAdministratorResource> lro = await managedInstanceAdministrator.UpdateAsync(WaitUntil.Completed, data);
            ManagedInstanceAdministratorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedInstanceAdministratorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete administrator of managed instance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAdministratorOfManagedInstance()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceAdministratorDelete.json
            // this example is just showing the usage of "ManagedInstanceAdministrators_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedInstanceAdministratorResource created on azure
            // for more information of creating ManagedInstanceAdministratorResource, please refer to the document of ManagedInstanceAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string managedInstanceName = "managedInstance";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier managedInstanceAdministratorResourceId = ManagedInstanceAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, administratorName);
            ManagedInstanceAdministratorResource managedInstanceAdministrator = client.GetManagedInstanceAdministratorResource(managedInstanceAdministratorResourceId);

            // invoke the operation
            await managedInstanceAdministrator.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
