// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedDatabaseVulnerabilityAssessmentScanResource
    {
        // Executes a database's vulnerability assessment scan.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task InitiateScan_ExecutesADatabaseSVulnerabilityAssessmentScan()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScansExecute.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_InitiateScan" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentScanResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentScanResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scan01";
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentScanResourceId = ManagedDatabaseVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId);
            ManagedDatabaseVulnerabilityAssessmentScanResource managedDatabaseVulnerabilityAssessmentScan = client.GetManagedDatabaseVulnerabilityAssessmentScanResource(managedDatabaseVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            await managedDatabaseVulnerabilityAssessmentScan.InitiateScanAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Export a database's vulnerability assessment scan results.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Export_ExportADatabaseSVulnerabilityAssessmentScanResults()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanExport.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_Export" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentScanResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentScanResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4799";
            string managedInstanceName = "vulnerabilityassessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scan001";
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentScanResourceId = ManagedDatabaseVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId);
            ManagedDatabaseVulnerabilityAssessmentScanResource managedDatabaseVulnerabilityAssessmentScan = client.GetManagedDatabaseVulnerabilityAssessmentScanResource(managedDatabaseVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            DatabaseVulnerabilityAssessmentScansExport result = await managedDatabaseVulnerabilityAssessmentScan.ExportAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentScanResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentScanResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentScanResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scan001";
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentScanResourceId = ManagedDatabaseVulnerabilityAssessmentScanResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanId);
            ManagedDatabaseVulnerabilityAssessmentScanResource managedDatabaseVulnerabilityAssessmentScan = client.GetManagedDatabaseVulnerabilityAssessmentScanResource(managedDatabaseVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            ManagedDatabaseVulnerabilityAssessmentScanResource result = await managedDatabaseVulnerabilityAssessmentScan.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VulnerabilityAssessmentScanRecordData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
