// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedDatabaseVulnerabilityAssessmentScanCollection
    {
        // Gets the list of a database vulnerability assessment scan records
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetsTheListOfADatabaseVulnerabilityAssessmentScanRecords()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanRecordsListByDatabase.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_ListByDatabase" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentScanResource
            ManagedDatabaseVulnerabilityAssessmentScanCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentScans();

            // invoke the operation and iterate over the result
            await foreach (ManagedDatabaseVulnerabilityAssessmentScanResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                VulnerabilityAssessmentScanRecordData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentScanResource
            ManagedDatabaseVulnerabilityAssessmentScanCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            ManagedDatabaseVulnerabilityAssessmentScanResource result = await collection.GetAsync(scanId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VulnerabilityAssessmentScanRecordData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentScanResource
            ManagedDatabaseVulnerabilityAssessmentScanCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            bool result = await collection.ExistsAsync(scanId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a database vulnerability assessment scan record by scan ID
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsADatabaseVulnerabilityAssessmentScanRecordByScanID()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentScanRecordsGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string managedInstanceName = "vulnerabilityassessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentScanResource
            ManagedDatabaseVulnerabilityAssessmentScanCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            NullableResponse<ManagedDatabaseVulnerabilityAssessmentScanResource> response = await collection.GetIfExistsAsync(scanId);
            ManagedDatabaseVulnerabilityAssessmentScanResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                VulnerabilityAssessmentScanRecordData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
