// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
    {
        // Gets a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string managedInstanceName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Master;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId = ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource managedDatabaseVulnerabilityAssessmentRuleBaseline = client.GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResource(managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource result = await managedDatabaseVulnerabilityAssessmentRuleBaseline.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineCreate.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId = ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource managedDatabaseVulnerabilityAssessmentRuleBaseline = client.GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResource(managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            DatabaseVulnerabilityAssessmentRuleBaselineData data = new DatabaseVulnerabilityAssessmentRuleBaselineData()
            {
                BaselineResults =
{
new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userA","SELECT"
}),new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userB","SELECT"
}),new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userC","SELECT","tableId_4"
})
},
            };
            ArmOperation<ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource> lro = await managedDatabaseVulnerabilityAssessmentRuleBaseline.UpdateAsync(WaitUntil.Completed, data);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Removes a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemovesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineDelete.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId = ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource managedDatabaseVulnerabilityAssessmentRuleBaseline = client.GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResource(managedDatabaseVulnerabilityAssessmentRuleBaselineResourceId);

            // invoke the operation
            await managedDatabaseVulnerabilityAssessmentRuleBaseline.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
