// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedDatabaseVulnerabilityAssessmentRuleBaselineCollection
    {
        // Gets a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string managedInstanceName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Master;
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource result = await collection.GetAsync(ruleId, baselineName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string managedInstanceName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Master;
            bool result = await collection.ExistsAsync(ruleId, baselineName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string managedInstanceName = "vulnerabilityaseessmenttest-6411";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Master;
            NullableResponse<ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource> response = await collection.GetIfExistsAsync(ruleId, baselineName);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DatabaseVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineCreate.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // get the collection of this ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineCollection collection = managedDatabaseVulnerabilityAssessment.GetManagedDatabaseVulnerabilityAssessmentRuleBaselines();

            // invoke the operation
            string ruleId = "VA1001";
            VulnerabilityAssessmentPolicyBaselineName baselineName = VulnerabilityAssessmentPolicyBaselineName.Default;
            DatabaseVulnerabilityAssessmentRuleBaselineData data = new DatabaseVulnerabilityAssessmentRuleBaselineData()
            {
                BaselineResults =
{
new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userA","SELECT"
}),new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userB","SELECT"
}),new DatabaseVulnerabilityAssessmentRuleBaselineItem(new string[]
{
"userC","SELECT","tableId_4"
})
},
            };
            ArmOperation<ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleId, baselineName, data);
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentRuleBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
