// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_ManagedDatabaseVulnerabilityAssessmentResource
    {
        // Get a database's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADatabaseSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // invoke the operation
            ManagedDatabaseVulnerabilityAssessmentResource result = await managedDatabaseVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADatabaseSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentCreateMax.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // invoke the operation
            DatabaseVulnerabilityAssessmentData data = new DatabaseVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new VulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EmailSubscriptionAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<ManagedDatabaseVulnerabilityAssessmentResource> lro = await managedDatabaseVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            ManagedDatabaseVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a database's vulnerability assessment with minimal parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADatabaseSVulnerabilityAssessmentWithMinimalParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentCreateMin.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // invoke the operation
            DatabaseVulnerabilityAssessmentData data = new DatabaseVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<ManagedDatabaseVulnerabilityAssessmentResource> lro = await managedDatabaseVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            ManagedDatabaseVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Remove a database's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemoveADatabaseSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentDelete.json
            // this example is just showing the usage of "ManagedDatabaseVulnerabilityAssessments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedDatabaseVulnerabilityAssessmentResource created on azure
            // for more information of creating ManagedDatabaseVulnerabilityAssessmentResource, please refer to the document of ManagedDatabaseVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string managedInstanceName = "vulnerabilityaseessmenttest-6440";
            string databaseName = "testdb";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier managedDatabaseVulnerabilityAssessmentResourceId = ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName);
            ManagedDatabaseVulnerabilityAssessmentResource managedDatabaseVulnerabilityAssessment = client.GetManagedDatabaseVulnerabilityAssessmentResource(managedDatabaseVulnerabilityAssessmentResourceId);

            // invoke the operation
            await managedDatabaseVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
