// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_MaintenanceWindowOptionResource
    {
        // Gets a list of available maintenance windows for a selected database.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAListOfAvailableMaintenanceWindowsForASelectedDatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetMaintenanceWindowOptions.json
            // this example is just showing the usage of "MaintenanceWindowOptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MaintenanceWindowOptionResource created on azure
            // for more information of creating MaintenanceWindowOptionResource, please refer to the document of MaintenanceWindowOptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            ResourceIdentifier maintenanceWindowOptionResourceId = MaintenanceWindowOptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName);
            MaintenanceWindowOptionResource maintenanceWindowOption = client.GetMaintenanceWindowOptionResource(maintenanceWindowOptionResourceId);

            // invoke the operation
            string maintenanceWindowOptionsName = "current";
            MaintenanceWindowOptionResource result = await maintenanceWindowOption.GetAsync(maintenanceWindowOptionsName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MaintenanceWindowOptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
