// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_LedgerDigestUploadResource
    {
        // Gets the current ledger digest upload configuration for a database.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheCurrentLedgerDigestUploadConfigurationForADatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-02-01-preview/examples/LedgerDigestUploadsGet.json
            // this example is just showing the usage of "LedgerDigestUploads_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LedgerDigestUploadResource created on azure
            // for more information of creating LedgerDigestUploadResource, please refer to the document of LedgerDigestUploadResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "ledgertestrg";
            string serverName = "ledgertestserver";
            string databaseName = "testdb";
            LedgerDigestUploadsName ledgerDigestUploads = LedgerDigestUploadsName.Current;
            ResourceIdentifier ledgerDigestUploadResourceId = LedgerDigestUploadResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, ledgerDigestUploads);
            LedgerDigestUploadResource ledgerDigestUpload = client.GetLedgerDigestUploadResource(ledgerDigestUploadResourceId);

            // invoke the operation
            LedgerDigestUploadResource result = await ledgerDigestUpload.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LedgerDigestUploadData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Enables ledger digest upload configuration for a database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_EnablesLedgerDigestUploadConfigurationForADatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-02-01-preview/examples/LedgerDigestUploadsEnable.json
            // this example is just showing the usage of "LedgerDigestUploads_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LedgerDigestUploadResource created on azure
            // for more information of creating LedgerDigestUploadResource, please refer to the document of LedgerDigestUploadResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "ledgertestrg";
            string serverName = "ledgertestserver";
            string databaseName = "testdb";
            LedgerDigestUploadsName ledgerDigestUploads = LedgerDigestUploadsName.Current;
            ResourceIdentifier ledgerDigestUploadResourceId = LedgerDigestUploadResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, ledgerDigestUploads);
            LedgerDigestUploadResource ledgerDigestUpload = client.GetLedgerDigestUploadResource(ledgerDigestUploadResourceId);

            // invoke the operation
            LedgerDigestUploadData data = new LedgerDigestUploadData()
            {
                DigestStorageEndpoint = "https://MyAccount.blob.core.windows.net",
            };
            ArmOperation<LedgerDigestUploadResource> lro = await ledgerDigestUpload.UpdateAsync(WaitUntil.Completed, data);
            LedgerDigestUploadResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LedgerDigestUploadData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Disables uploading ledger digests for a database
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Disable_DisablesUploadingLedgerDigestsForADatabase()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2021-02-01-preview/examples/LedgerDigestUploadsDisable.json
            // this example is just showing the usage of "LedgerDigestUploads_Disable" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LedgerDigestUploadResource created on azure
            // for more information of creating LedgerDigestUploadResource, please refer to the document of LedgerDigestUploadResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "ledgertestrg";
            string serverName = "ledgertestserver";
            string databaseName = "testdb";
            LedgerDigestUploadsName ledgerDigestUploads = LedgerDigestUploadsName.Current;
            ResourceIdentifier ledgerDigestUploadResourceId = LedgerDigestUploadResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, ledgerDigestUploads);
            LedgerDigestUploadResource ledgerDigestUpload = client.GetLedgerDigestUploadResource(ledgerDigestUploadResourceId);

            // invoke the operation
            ArmOperation<LedgerDigestUploadResource> lro = await ledgerDigestUpload.DisableAsync(WaitUntil.Completed);
            LedgerDigestUploadResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LedgerDigestUploadData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
