// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_InstanceFailoverGroupResource
    {
        // Get failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/InstanceFailoverGroupGet.json
            // this example is just showing the usage of "InstanceFailoverGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InstanceFailoverGroupResource created on azure
            // for more information of creating InstanceFailoverGroupResource, please refer to the document of InstanceFailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string failoverGroupName = "failover-group-test";
            ResourceIdentifier instanceFailoverGroupResourceId = InstanceFailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, failoverGroupName);
            InstanceFailoverGroupResource instanceFailoverGroup = client.GetInstanceFailoverGroupResource(instanceFailoverGroupResourceId);

            // invoke the operation
            InstanceFailoverGroupResource result = await instanceFailoverGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InstanceFailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/InstanceFailoverGroupCreateOrUpdate.json
            // this example is just showing the usage of "InstanceFailoverGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InstanceFailoverGroupResource created on azure
            // for more information of creating InstanceFailoverGroupResource, please refer to the document of InstanceFailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string failoverGroupName = "failover-group-test-3";
            ResourceIdentifier instanceFailoverGroupResourceId = InstanceFailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, failoverGroupName);
            InstanceFailoverGroupResource instanceFailoverGroup = client.GetInstanceFailoverGroupResource(instanceFailoverGroupResourceId);

            // invoke the operation
            InstanceFailoverGroupData data = new InstanceFailoverGroupData()
            {
                SecondaryType = GeoSecondaryInstanceType.Geo,
                ReadWriteEndpoint = new InstanceFailoverGroupReadWriteEndpoint(ReadWriteEndpointFailoverPolicy.Automatic)
                {
                    FailoverWithDataLossGracePeriodMinutes = 480,
                },
                ReadOnlyEndpointFailoverPolicy = ReadOnlyEndpointFailoverPolicy.Disabled,
                PartnerRegions =
{
new PartnerRegionInfo()
{
Location = new AzureLocation("Japan West"),
}
},
                ManagedInstancePairs =
{
new ManagedInstancePairInfo()
{
PrimaryManagedInstanceId = new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance"),
PartnerManagedInstanceId = new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance"),
}
},
            };
            ArmOperation<InstanceFailoverGroupResource> lro = await instanceFailoverGroup.UpdateAsync(WaitUntil.Completed, data);
            InstanceFailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InstanceFailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/InstanceFailoverGroupDelete.json
            // this example is just showing the usage of "InstanceFailoverGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InstanceFailoverGroupResource created on azure
            // for more information of creating InstanceFailoverGroupResource, please refer to the document of InstanceFailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string failoverGroupName = "failover-group-test-1";
            ResourceIdentifier instanceFailoverGroupResourceId = InstanceFailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, failoverGroupName);
            InstanceFailoverGroupResource instanceFailoverGroup = client.GetInstanceFailoverGroupResource(instanceFailoverGroupResourceId);

            // invoke the operation
            await instanceFailoverGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Planned failover of a failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Failover_PlannedFailoverOfAFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/InstanceFailoverGroupFailover.json
            // this example is just showing the usage of "InstanceFailoverGroups_Failover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InstanceFailoverGroupResource created on azure
            // for more information of creating InstanceFailoverGroupResource, please refer to the document of InstanceFailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan West");
            string failoverGroupName = "failover-group-test-3";
            ResourceIdentifier instanceFailoverGroupResourceId = InstanceFailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, failoverGroupName);
            InstanceFailoverGroupResource instanceFailoverGroup = client.GetInstanceFailoverGroupResource(instanceFailoverGroupResourceId);

            // invoke the operation
            ArmOperation<InstanceFailoverGroupResource> lro = await instanceFailoverGroup.FailoverAsync(WaitUntil.Completed);
            InstanceFailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InstanceFailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Forced failover of a failover group allowing data loss
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ForceFailoverAllowDataLoss_ForcedFailoverOfAFailoverGroupAllowingDataLoss()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/InstanceFailoverGroupForceFailoverAllowDataLoss.json
            // this example is just showing the usage of "InstanceFailoverGroups_ForceFailoverAllowDataLoss" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this InstanceFailoverGroupResource created on azure
            // for more information of creating InstanceFailoverGroupResource, please refer to the document of InstanceFailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan West");
            string failoverGroupName = "failover-group-test-3";
            ResourceIdentifier instanceFailoverGroupResourceId = InstanceFailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, failoverGroupName);
            InstanceFailoverGroupResource instanceFailoverGroup = client.GetInstanceFailoverGroupResource(instanceFailoverGroupResourceId);

            // invoke the operation
            ArmOperation<InstanceFailoverGroupResource> lro = await instanceFailoverGroup.ForceFailoverAllowDataLossAsync(WaitUntil.Completed);
            InstanceFailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            InstanceFailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
