// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_GeoBackupPolicyResource
    {
        // Update geo backup policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateGeoBackupPolicy()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/stable/2014-04-01/examples/GeoBackupPoliciesCreateOrUpdate.json
            // this example is just showing the usage of "GeoBackupPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GeoBackupPolicyResource created on azure
            // for more information of creating GeoBackupPolicyResource, please refer to the document of GeoBackupPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string serverName = "sqlcrudtest-5961";
            string databaseName = "testdw";
            GeoBackupPolicyName geoBackupPolicyName = GeoBackupPolicyName.Default;
            ResourceIdentifier geoBackupPolicyResourceId = GeoBackupPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, geoBackupPolicyName);
            GeoBackupPolicyResource geoBackupPolicy = client.GetGeoBackupPolicyResource(geoBackupPolicyResourceId);

            // invoke the operation
            GeoBackupPolicyData data = new GeoBackupPolicyData(GeoBackupPolicyState.Enabled);
            ArmOperation<GeoBackupPolicyResource> lro = await geoBackupPolicy.UpdateAsync(WaitUntil.Completed, data);
            GeoBackupPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GeoBackupPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get geo backup policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetGeoBackupPolicy()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/stable/2014-04-01/examples/GeoBackupPoliciesGet.json
            // this example is just showing the usage of "GeoBackupPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GeoBackupPolicyResource created on azure
            // for more information of creating GeoBackupPolicyResource, please refer to the document of GeoBackupPolicyResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string serverName = "sqlcrudtest-5961";
            string databaseName = "testdw";
            GeoBackupPolicyName geoBackupPolicyName = GeoBackupPolicyName.Default;
            ResourceIdentifier geoBackupPolicyResourceId = GeoBackupPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, geoBackupPolicyName);
            GeoBackupPolicyResource geoBackupPolicy = client.GetGeoBackupPolicyResource(geoBackupPolicyResourceId);

            // invoke the operation
            GeoBackupPolicyResource result = await geoBackupPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GeoBackupPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
