// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_FailoverGroupResource
    {
        // Get failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupGet.json
            // this example is just showing the usage of "FailoverGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failovergroupprimaryserver";
            string failoverGroupName = "failovergrouptest3";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            FailoverGroupResource result = await failoverGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupDelete.json
            // this example is just showing the usage of "FailoverGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failover-group-primary-server";
            string failoverGroupName = "failover-group-test-1";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            await failoverGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Add database to failover group with standby secondary on partner server.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AddDatabaseToFailoverGroupWithStandbySecondaryOnPartnerServer()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupUpdateStandbySecondary.json
            // this example is just showing the usage of "FailoverGroups_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failover-group-primary-server";
            string failoverGroupName = "failover-group-test-1";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            FailoverGroupPatch patch = new FailoverGroupPatch()
            {
                ReadWriteEndpoint = new FailoverGroupReadWriteEndpoint(ReadWriteEndpointFailoverPolicy.Automatic)
                {
                    FailoverWithDataLossGracePeriodMinutes = 120,
                },
                FailoverDatabases =
{
new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1")
},
                SecondaryType = FailoverGroupDatabasesSecondaryType.Standby,
            };
            ArmOperation<FailoverGroupResource> lro = await failoverGroup.UpdateAsync(WaitUntil.Completed, patch);
            FailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupUpdate.json
            // this example is just showing the usage of "FailoverGroups_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failover-group-primary-server";
            string failoverGroupName = "failover-group-test-1";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            FailoverGroupPatch patch = new FailoverGroupPatch()
            {
                ReadWriteEndpoint = new FailoverGroupReadWriteEndpoint(ReadWriteEndpointFailoverPolicy.Automatic)
                {
                    FailoverWithDataLossGracePeriodMinutes = 120,
                },
                FailoverDatabases =
{
new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1")
},
            };
            ArmOperation<FailoverGroupResource> lro = await failoverGroup.UpdateAsync(WaitUntil.Completed, patch);
            FailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Planned failover of a failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Failover_PlannedFailoverOfAFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupFailover.json
            // this example is just showing the usage of "FailoverGroups_Failover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failover-group-secondary-server";
            string failoverGroupName = "failover-group-test-3";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            ArmOperation<FailoverGroupResource> lro = await failoverGroup.FailoverAsync(WaitUntil.Completed);
            FailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Forced failover of a failover group allowing data loss
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ForceFailoverAllowDataLoss_ForcedFailoverOfAFailoverGroupAllowingDataLoss()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupForceFailoverAllowDataLoss.json
            // this example is just showing the usage of "FailoverGroups_ForceFailoverAllowDataLoss" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failover-group-secondary-server";
            string failoverGroupName = "failover-group-test-3";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            ArmOperation<FailoverGroupResource> lro = await failoverGroup.ForceFailoverAllowDataLossAsync(WaitUntil.Completed);
            FailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Try planned before forced failover of a failover group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TryPlannedBeforeForcedFailover_TryPlannedBeforeForcedFailoverOfAFailoverGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2023-05-01-preview/examples/FailoverGroupTryPlannedBeforeForcedFailover.json
            // this example is just showing the usage of "FailoverGroups_TryPlannedBeforeForcedFailover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FailoverGroupResource created on azure
            // for more information of creating FailoverGroupResource, please refer to the document of FailoverGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "failovergroupsecondaryserver";
            string failoverGroupName = "failovergrouptest3";
            ResourceIdentifier failoverGroupResourceId = FailoverGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, failoverGroupName);
            FailoverGroupResource failoverGroup = client.GetFailoverGroupResource(failoverGroupResourceId);

            // invoke the operation
            ArmOperation<FailoverGroupResource> lro = await failoverGroup.TryPlannedBeforeForcedFailoverAsync(WaitUntil.Completed);
            FailoverGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FailoverGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
