// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A class representing a collection of <see cref="SpringBootSiteSummaryResource"/> and their operations.
    /// Each <see cref="SpringBootSiteSummaryResource"/> in the collection will belong to the same instance of <see cref="SpringBootSiteResource"/>.
    /// To get a <see cref="SpringBootSiteSummaryCollection"/> instance call the GetSpringBootSiteSummaries method from an instance of <see cref="SpringBootSiteResource"/>.
    /// </summary>
    public partial class SpringBootSiteSummaryCollection : ArmCollection, IEnumerable<SpringBootSiteSummaryResource>, IAsyncEnumerable<SpringBootSiteSummaryResource>
    {
        private readonly ClientDiagnostics _springBootSiteSummarySummariesClientDiagnostics;
        private readonly SummariesRestOperations _springBootSiteSummarySummariesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteSummaryCollection"/> class for mocking. </summary>
        protected SpringBootSiteSummaryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteSummaryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SpringBootSiteSummaryCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _springBootSiteSummarySummariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootSiteSummaryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SpringBootSiteSummaryResource.ResourceType, out string springBootSiteSummarySummariesApiVersion);
            _springBootSiteSummarySummariesRestClient = new SummariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, springBootSiteSummarySummariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SpringBootSiteResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SpringBootSiteResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the Summaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual async Task<Response<SpringBootSiteSummaryResource>> GetAsync(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.Get");
            scope.Start();
            try
            {
                var response = await _springBootSiteSummarySummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the Summaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual Response<SpringBootSiteSummaryResource> Get(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.Get");
            scope.Start();
            try
            {
                var response = _springBootSiteSummarySummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the Summaries resource in springbootsites.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_ListBySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SpringBootSiteSummaryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootSiteSummaryResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSiteSummarySummariesRestClient.CreateListBySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSiteSummarySummariesRestClient.CreateListBySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteSummaryResource(Client, SpringBootSiteSummaryData.DeserializeSpringBootSiteSummaryData(e)), _springBootSiteSummarySummariesClientDiagnostics, Pipeline, "SpringBootSiteSummaryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the Summaries resource in springbootsites.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_ListBySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SpringBootSiteSummaryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootSiteSummaryResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSiteSummarySummariesRestClient.CreateListBySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSiteSummarySummariesRestClient.CreateListBySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteSummaryResource(Client, SpringBootSiteSummaryData.DeserializeSpringBootSiteSummaryData(e)), _springBootSiteSummarySummariesClientDiagnostics, Pipeline, "SpringBootSiteSummaryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _springBootSiteSummarySummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual Response<bool> Exists(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.Exists");
            scope.Start();
            try
            {
                var response = _springBootSiteSummarySummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual async Task<NullableResponse<SpringBootSiteSummaryResource>> GetIfExistsAsync(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _springBootSiteSummarySummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteSummaryResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The name of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="summaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="summaryName"/> is null. </exception>
        public virtual NullableResponse<SpringBootSiteSummaryResource> GetIfExists(string summaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(summaryName, nameof(summaryName));

            using var scope = _springBootSiteSummarySummariesClientDiagnostics.CreateScope("SpringBootSiteSummaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _springBootSiteSummarySummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, summaryName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteSummaryResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SpringBootSiteSummaryResource> IEnumerable<SpringBootSiteSummaryResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SpringBootSiteSummaryResource> IAsyncEnumerable<SpringBootSiteSummaryResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
