// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A Class representing a SpringBootSiteErrorSummary along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SpringBootSiteErrorSummaryResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSpringBootSiteErrorSummaryResource method.
    /// Otherwise you can get one from its parent resource <see cref="SpringBootSiteResource"/> using the GetSpringBootSiteErrorSummary method.
    /// </summary>
    public partial class SpringBootSiteErrorSummaryResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SpringBootSiteErrorSummaryResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="siteName"> The siteName. </param>
        /// <param name="errorSummaryName"> The errorSummaryName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string siteName, string errorSummaryName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _springBootSiteErrorSummaryErrorSummariesClientDiagnostics;
        private readonly ErrorSummariesRestOperations _springBootSiteErrorSummaryErrorSummariesRestClient;
        private readonly SpringBootSiteErrorSummaryData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.OffAzureSpringBoot/springbootsites/errorSummaries";

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteErrorSummaryResource"/> class for mocking. </summary>
        protected SpringBootSiteErrorSummaryResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteErrorSummaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SpringBootSiteErrorSummaryResource(ArmClient client, SpringBootSiteErrorSummaryData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteErrorSummaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SpringBootSiteErrorSummaryResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _springBootSiteErrorSummaryErrorSummariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string springBootSiteErrorSummaryErrorSummariesApiVersion);
            _springBootSiteErrorSummaryErrorSummariesRestClient = new ErrorSummariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, springBootSiteErrorSummaryErrorSummariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SpringBootSiteErrorSummaryData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the ErrorSummaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SpringBootSiteErrorSummaryResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryResource.Get");
            scope.Start();
            try
            {
                var response = await _springBootSiteErrorSummaryErrorSummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the ErrorSummaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SpringBootSiteErrorSummaryResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryResource.Get");
            scope.Start();
            try
            {
                var response = _springBootSiteErrorSummaryErrorSummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
