// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A class representing a collection of <see cref="SpringBootSiteErrorSummaryResource"/> and their operations.
    /// Each <see cref="SpringBootSiteErrorSummaryResource"/> in the collection will belong to the same instance of <see cref="SpringBootSiteResource"/>.
    /// To get a <see cref="SpringBootSiteErrorSummaryCollection"/> instance call the GetSpringBootSiteErrorSummaries method from an instance of <see cref="SpringBootSiteResource"/>.
    /// </summary>
    public partial class SpringBootSiteErrorSummaryCollection : ArmCollection, IEnumerable<SpringBootSiteErrorSummaryResource>, IAsyncEnumerable<SpringBootSiteErrorSummaryResource>
    {
        private readonly ClientDiagnostics _springBootSiteErrorSummaryErrorSummariesClientDiagnostics;
        private readonly ErrorSummariesRestOperations _springBootSiteErrorSummaryErrorSummariesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteErrorSummaryCollection"/> class for mocking. </summary>
        protected SpringBootSiteErrorSummaryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteErrorSummaryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SpringBootSiteErrorSummaryCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _springBootSiteErrorSummaryErrorSummariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootSiteErrorSummaryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SpringBootSiteErrorSummaryResource.ResourceType, out string springBootSiteErrorSummaryErrorSummariesApiVersion);
            _springBootSiteErrorSummaryErrorSummariesRestClient = new ErrorSummariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, springBootSiteErrorSummaryErrorSummariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SpringBootSiteResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SpringBootSiteResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the ErrorSummaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual async Task<Response<SpringBootSiteErrorSummaryResource>> GetAsync(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.Get");
            scope.Start();
            try
            {
                var response = await _springBootSiteErrorSummaryErrorSummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the ErrorSummaries resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual Response<SpringBootSiteErrorSummaryResource> Get(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.Get");
            scope.Start();
            try
            {
                var response = _springBootSiteErrorSummaryErrorSummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the ErrorSummaries resource in springbootsites.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_ListBySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SpringBootSiteErrorSummaryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootSiteErrorSummaryResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSiteErrorSummaryErrorSummariesRestClient.CreateListBySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSiteErrorSummaryErrorSummariesRestClient.CreateListBySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteErrorSummaryResource(Client, SpringBootSiteErrorSummaryData.DeserializeSpringBootSiteErrorSummaryData(e)), _springBootSiteErrorSummaryErrorSummariesClientDiagnostics, Pipeline, "SpringBootSiteErrorSummaryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the ErrorSummaries resource in springbootsites.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_ListBySite</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SpringBootSiteErrorSummaryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootSiteErrorSummaryResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSiteErrorSummaryErrorSummariesRestClient.CreateListBySiteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSiteErrorSummaryErrorSummariesRestClient.CreateListBySiteNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteErrorSummaryResource(Client, SpringBootSiteErrorSummaryData.DeserializeSpringBootSiteErrorSummaryData(e)), _springBootSiteErrorSummaryErrorSummariesClientDiagnostics, Pipeline, "SpringBootSiteErrorSummaryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _springBootSiteErrorSummaryErrorSummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual Response<bool> Exists(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.Exists");
            scope.Start();
            try
            {
                var response = _springBootSiteErrorSummaryErrorSummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual async Task<NullableResponse<SpringBootSiteErrorSummaryResource>> GetIfExistsAsync(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _springBootSiteErrorSummaryErrorSummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteErrorSummaryResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/errorSummaries/{errorSummaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ErrorSummaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteErrorSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="errorSummaryName"> The name of error summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="errorSummaryName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="errorSummaryName"/> is null. </exception>
        public virtual NullableResponse<SpringBootSiteErrorSummaryResource> GetIfExists(string errorSummaryName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(errorSummaryName, nameof(errorSummaryName));

            using var scope = _springBootSiteErrorSummaryErrorSummariesClientDiagnostics.CreateScope("SpringBootSiteErrorSummaryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _springBootSiteErrorSummaryErrorSummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, errorSummaryName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteErrorSummaryResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteErrorSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SpringBootSiteErrorSummaryResource> IEnumerable<SpringBootSiteErrorSummaryResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SpringBootSiteErrorSummaryResource> IAsyncEnumerable<SpringBootSiteErrorSummaryResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
