// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SpringAppDiscovery.Models;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A class representing the SpringBootSite data model.
    /// The springbootsites envelope resource definition.
    /// Serialized Name: SpringbootsitesModel
    /// </summary>
    public partial class SpringBootSiteData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteData"/>. </summary>
        /// <param name="location"> The location. </param>
        public SpringBootSiteData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties">
        /// The springbootsites resource definition.
        /// Serialized Name: SpringbootsitesModel.properties
        /// </param>
        /// <param name="extendedLocation">
        /// The extended location definition.
        /// Serialized Name: SpringbootsitesModel.extendedLocation
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootSiteData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, SpringBootSiteProperties properties, SpringBootSiteModelExtendedLocation extendedLocation, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Properties = properties;
            ExtendedLocation = extendedLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteData"/> for deserialization. </summary>
        internal SpringBootSiteData()
        {
        }

        /// <summary>
        /// The springbootsites resource definition.
        /// Serialized Name: SpringbootsitesModel.properties
        /// </summary>
        public SpringBootSiteProperties Properties { get; set; }
        /// <summary>
        /// The extended location definition.
        /// Serialized Name: SpringbootsitesModel.extendedLocation
        /// </summary>
        public SpringBootSiteModelExtendedLocation ExtendedLocation { get; set; }
    }
}
