// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A class representing a collection of <see cref="SpringBootSiteResource"/> and their operations.
    /// Each <see cref="SpringBootSiteResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="SpringBootSiteCollection"/> instance call the GetSpringBootSites method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class SpringBootSiteCollection : ArmCollection, IEnumerable<SpringBootSiteResource>, IAsyncEnumerable<SpringBootSiteResource>
    {
        private readonly ClientDiagnostics _springBootSitespringbootsitesClientDiagnostics;
        private readonly SpringbootsitesRestOperations _springBootSitespringbootsitesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteCollection"/> class for mocking. </summary>
        protected SpringBootSiteCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootSiteCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SpringBootSiteCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _springBootSitespringbootsitesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootSiteResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SpringBootSiteResource.ResourceType, out string springBootSitespringbootsitesApiVersion);
            _springBootSitespringbootsitesRestClient = new SpringbootsitesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, springBootSitespringbootsitesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="data"> Create a springbootsites payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SpringBootSiteResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string springbootsitesName, SpringBootSiteData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _springBootSitespringbootsitesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, data, cancellationToken).ConfigureAwait(false);
                var uri = _springBootSitespringbootsitesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SpringAppDiscoveryArmOperation<SpringBootSiteResource>(Response.FromValue(new SpringBootSiteResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="data"> Create a springbootsites payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SpringBootSiteResource> CreateOrUpdate(WaitUntil waitUntil, string springbootsitesName, SpringBootSiteData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _springBootSitespringbootsitesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, data, cancellationToken);
                var uri = _springBootSitespringbootsitesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SpringAppDiscoveryArmOperation<SpringBootSiteResource>(Response.FromValue(new SpringBootSiteResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual async Task<Response<SpringBootSiteResource>> GetAsync(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.Get");
            scope.Start();
            try
            {
                var response = await _springBootSitespringbootsitesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual Response<SpringBootSiteResource> Get(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.Get");
            scope.Start();
            try
            {
                var response = _springBootSitespringbootsitesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List springbootsites resource by resourceGroup.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootSiteResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSitespringbootsitesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSitespringbootsitesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteResource(Client, SpringBootSiteData.DeserializeSpringBootSiteData(e)), _springBootSitespringbootsitesClientDiagnostics, Pipeline, "SpringBootSiteCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootsites resource by resourceGroup.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootSiteResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootSitespringbootsitesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootSitespringbootsitesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteResource(Client, SpringBootSiteData.DeserializeSpringBootSiteData(e)), _springBootSitespringbootsitesClientDiagnostics, Pipeline, "SpringBootSiteCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.Exists");
            scope.Start();
            try
            {
                var response = await _springBootSitespringbootsitesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual Response<bool> Exists(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.Exists");
            scope.Start();
            try
            {
                var response = _springBootSitespringbootsitesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual async Task<NullableResponse<SpringBootSiteResource>> GetIfExistsAsync(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _springBootSitespringbootsitesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        public virtual NullableResponse<SpringBootSiteResource> GetIfExists(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootsitesName, nameof(springbootsitesName));

            using var scope = _springBootSitespringbootsitesClientDiagnostics.CreateScope("SpringBootSiteCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _springBootSitespringbootsitesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, springbootsitesName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootSiteResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootSiteResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SpringBootSiteResource> IEnumerable<SpringBootSiteResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SpringBootSiteResource> IAsyncEnumerable<SpringBootSiteResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
