// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary>
    /// A class representing a collection of <see cref="SpringBootAppResource"/> and their operations.
    /// Each <see cref="SpringBootAppResource"/> in the collection will belong to the same instance of <see cref="SpringBootSiteResource"/>.
    /// To get a <see cref="SpringBootAppCollection"/> instance call the GetSpringBootApps method from an instance of <see cref="SpringBootSiteResource"/>.
    /// </summary>
    public partial class SpringBootAppCollection : ArmCollection, IEnumerable<SpringBootAppResource>, IAsyncEnumerable<SpringBootAppResource>
    {
        private readonly ClientDiagnostics _springBootAppspringbootappsClientDiagnostics;
        private readonly SpringbootappsRestOperations _springBootAppspringbootappsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SpringBootAppCollection"/> class for mocking. </summary>
        protected SpringBootAppCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SpringBootAppCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SpringBootAppCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _springBootAppspringbootappsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootAppResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SpringBootAppResource.ResourceType, out string springBootAppspringbootappsApiVersion);
            _springBootAppspringbootappsRestClient = new SpringbootappsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, springBootAppspringbootappsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SpringBootSiteResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SpringBootSiteResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a springbootapps resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual async Task<Response<SpringBootAppResource>> GetAsync(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.Get");
            scope.Start();
            try
            {
                var response = await _springBootAppspringbootappsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootAppResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a springbootapps resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual Response<SpringBootAppResource> Get(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.Get");
            scope.Start();
            try
            {
                var response = _springBootAppspringbootappsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SpringBootAppResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List springbootapps resource by resourceGroup
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootAppResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootAppspringbootappsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootAppspringbootappsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootAppResource(Client, SpringBootAppData.DeserializeSpringBootAppData(e)), _springBootAppspringbootappsClientDiagnostics, Pipeline, "SpringBootAppCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootapps resource by resourceGroup
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootAppResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _springBootAppspringbootappsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _springBootAppspringbootappsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootAppResource(Client, SpringBootAppData.DeserializeSpringBootAppData(e)), _springBootAppspringbootappsClientDiagnostics, Pipeline, "SpringBootAppCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.Exists");
            scope.Start();
            try
            {
                var response = await _springBootAppspringbootappsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual Response<bool> Exists(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.Exists");
            scope.Start();
            try
            {
                var response = _springBootAppspringbootappsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual async Task<NullableResponse<SpringBootAppResource>> GetIfExistsAsync(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _springBootAppspringbootappsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootAppResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootAppResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootappsName"> The springbootapps name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="springbootappsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootappsName"/> is null. </exception>
        public virtual NullableResponse<SpringBootAppResource> GetIfExists(string springbootappsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(springbootappsName, nameof(springbootappsName));

            using var scope = _springBootAppspringbootappsClientDiagnostics.CreateScope("SpringBootAppCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _springBootAppspringbootappsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, springbootappsName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SpringBootAppResource>(response.GetRawResponse());
                return Response.FromValue(new SpringBootAppResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SpringBootAppResource> IEnumerable<SpringBootAppResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SpringBootAppResource> IAsyncEnumerable<SpringBootAppResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
