// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// List of Sites.
    /// Serialized Name: SummaryList
    /// </summary>
    internal partial class SummaryList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SummaryList"/>. </summary>
        internal SummaryList()
        {
            Value = new ChangeTrackingList<SpringBootSiteSummaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="SummaryList"/>. </summary>
        /// <param name="value">
        /// List of Sites.
        /// Serialized Name: SummaryList.value
        /// </param>
        /// <param name="nextLink">
        /// Url to follow for getting next page of resources.
        /// Serialized Name: SummaryList.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SummaryList(IReadOnlyList<SpringBootSiteSummaryData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// List of Sites.
        /// Serialized Name: SummaryList.value
        /// </summary>
        public IReadOnlyList<SpringBootSiteSummaryData> Value { get; }
        /// <summary>
        /// Url to follow for getting next page of resources.
        /// Serialized Name: SummaryList.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
