// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// Summaries properties
    /// Serialized Name: SummariesProperties
    /// </summary>
    public partial class SpringBootSiteSummariesProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteSummariesProperties"/>. </summary>
        public SpringBootSiteSummariesProperties()
        {
            Errors = new ChangeTrackingList<SpringBootSiteError>();
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteSummariesProperties"/>. </summary>
        /// <param name="discoveredServers">
        /// The of number discovered spring boot servers.
        /// Serialized Name: SummariesProperties.discoveredServers
        /// </param>
        /// <param name="discoveredApps">
        /// The of number discovered spring boot apps.
        /// Serialized Name: SummariesProperties.discoveredApps
        /// </param>
        /// <param name="errors">
        /// The list of errors.
        /// Serialized Name: SummariesProperties.errors
        /// </param>
        /// <param name="provisioningState">
        /// The resource provisioning state.
        /// Serialized Name: SummariesProperties.provisioningState
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootSiteSummariesProperties(long? discoveredServers, long? discoveredApps, IList<SpringBootSiteError> errors, SpringAppDiscoveryProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiscoveredServers = discoveredServers;
            DiscoveredApps = discoveredApps;
            Errors = errors;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The of number discovered spring boot servers.
        /// Serialized Name: SummariesProperties.discoveredServers
        /// </summary>
        public long? DiscoveredServers { get; set; }
        /// <summary>
        /// The of number discovered spring boot apps.
        /// Serialized Name: SummariesProperties.discoveredApps
        /// </summary>
        public long? DiscoveredApps { get; set; }
        /// <summary>
        /// The list of errors.
        /// Serialized Name: SummariesProperties.errors
        /// </summary>
        public IList<SpringBootSiteError> Errors { get; }
        /// <summary>
        /// The resource provisioning state.
        /// Serialized Name: SummariesProperties.provisioningState
        /// </summary>
        public SpringAppDiscoveryProvisioningState? ProvisioningState { get; set; }
    }
}
