// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The springbootsites resource definition.
    /// Serialized Name: SpringbootsitesProperties
    /// </summary>
    public partial class SpringBootSiteProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteProperties"/>. </summary>
        public SpringBootSiteProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteProperties"/>. </summary>
        /// <param name="masterSiteId">
        /// The master site ID from Azure Migrate.
        /// Serialized Name: SpringbootsitesProperties.masterSiteId
        /// </param>
        /// <param name="migrateProjectId">
        /// The migrate project ID from Azure Migrate.
        /// Serialized Name: SpringbootsitesProperties.migrateProjectId
        /// </param>
        /// <param name="provisioningState">
        /// The resource provisioning state.
        /// Serialized Name: SpringbootsitesProperties.provisioningState
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootSiteProperties(string masterSiteId, string migrateProjectId, SpringAppDiscoveryProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MasterSiteId = masterSiteId;
            MigrateProjectId = migrateProjectId;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The master site ID from Azure Migrate.
        /// Serialized Name: SpringbootsitesProperties.masterSiteId
        /// </summary>
        public string MasterSiteId { get; set; }
        /// <summary>
        /// The migrate project ID from Azure Migrate.
        /// Serialized Name: SpringbootsitesProperties.migrateProjectId
        /// </summary>
        public string MigrateProjectId { get; set; }
        /// <summary>
        /// The resource provisioning state.
        /// Serialized Name: SpringbootsitesProperties.provisioningState
        /// </summary>
        public SpringAppDiscoveryProvisioningState? ProvisioningState { get; set; }
    }
}
