// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// Defines the error.
    /// Serialized Name: Error
    /// </summary>
    public partial class SpringBootSiteError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteError"/>. </summary>
        public SpringBootSiteError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootSiteError"/>. </summary>
        /// <param name="id">
        /// The error ID.
        /// Serialized Name: Error.id
        /// </param>
        /// <param name="code">
        /// The error code.
        /// Serialized Name: Error.code
        /// </param>
        /// <param name="summaryMessage">
        /// The summarized error message.
        /// Serialized Name: Error.summaryMessage
        /// </param>
        /// <param name="runAsAccountId">
        /// The account ID used to login.
        /// Serialized Name: Error.runAsAccountId
        /// </param>
        /// <param name="message">
        /// The detailed error message.
        /// Serialized Name: Error.message
        /// </param>
        /// <param name="possibleCauses">
        /// The error possible causes.
        /// Serialized Name: Error.possibleCauses
        /// </param>
        /// <param name="recommendedAction">
        /// The error recommended action
        /// Serialized Name: Error.recommendedAction
        /// </param>
        /// <param name="severity">
        /// The error severity
        /// Serialized Name: Error.severity
        /// </param>
        /// <param name="updatedTimeStamp">
        /// Time when this error was last updated.
        /// Serialized Name: Error.updatedTimeStamp
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootSiteError(long? id, string code, string summaryMessage, string runAsAccountId, string message, string possibleCauses, string recommendedAction, string severity, DateTimeOffset? updatedTimeStamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Code = code;
            SummaryMessage = summaryMessage;
            RunAsAccountId = runAsAccountId;
            Message = message;
            PossibleCauses = possibleCauses;
            RecommendedAction = recommendedAction;
            Severity = severity;
            UpdatedTimeStamp = updatedTimeStamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The error ID.
        /// Serialized Name: Error.id
        /// </summary>
        public long? Id { get; set; }
        /// <summary>
        /// The error code.
        /// Serialized Name: Error.code
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// The summarized error message.
        /// Serialized Name: Error.summaryMessage
        /// </summary>
        public string SummaryMessage { get; set; }
        /// <summary>
        /// The account ID used to login.
        /// Serialized Name: Error.runAsAccountId
        /// </summary>
        public string RunAsAccountId { get; set; }
        /// <summary>
        /// The detailed error message.
        /// Serialized Name: Error.message
        /// </summary>
        public string Message { get; set; }
        /// <summary>
        /// The error possible causes.
        /// Serialized Name: Error.possibleCauses
        /// </summary>
        public string PossibleCauses { get; set; }
        /// <summary>
        /// The error recommended action
        /// Serialized Name: Error.recommendedAction
        /// </summary>
        public string RecommendedAction { get; set; }
        /// <summary>
        /// The error severity
        /// Serialized Name: Error.severity
        /// </summary>
        public string Severity { get; set; }
        /// <summary>
        /// Time when this error was last updated.
        /// Serialized Name: Error.updatedTimeStamp
        /// </summary>
        public DateTimeOffset? UpdatedTimeStamp { get; set; }
    }
}
