// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The springbootservers resource definition.
    /// Serialized Name: SpringbootserversProperties
    /// </summary>
    public partial class SpringBootServerProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootServerProperties"/>. </summary>
        /// <param name="server">
        /// Server is the target server name or ip address to discover of SpringBootServer.
        /// Serialized Name: SpringbootserversProperties.server
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="server"/> is null. </exception>
        public SpringBootServerProperties(string server)
        {
            Argument.AssertNotNull(server, nameof(server));

            Server = server;
            FqdnAndIPAddressList = new ChangeTrackingList<IPAddress>();
            Errors = new ChangeTrackingList<SpringBootSiteError>();
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootServerProperties"/>. </summary>
        /// <param name="port">
        /// Target server port for remote login
        /// Serialized Name: SpringbootserversProperties.port
        /// </param>
        /// <param name="server">
        /// Server is the target server name or ip address to discover of SpringBootServer.
        /// Serialized Name: SpringbootserversProperties.server
        /// </param>
        /// <param name="fqdnAndIPAddressList">
        /// The alternative FQDN or IP addresses to discover for this server
        /// Serialized Name: SpringbootserversProperties.fqdnAndIpAddressList
        /// </param>
        /// <param name="machineArmId">
        /// The machine Id from ARM
        /// Serialized Name: SpringbootserversProperties.machineArmId
        /// </param>
        /// <param name="totalApps">
        /// The total number of apps been discovered
        /// Serialized Name: SpringbootserversProperties.totalApps
        /// </param>
        /// <param name="springBootApps">
        /// The total number of spring boot apps been discovered
        /// Serialized Name: SpringbootserversProperties.springBootApps
        /// </param>
        /// <param name="errors">
        /// The list of errors.
        /// Serialized Name: SpringbootserversProperties.errors
        /// </param>
        /// <param name="provisioningState">
        /// The resource provisioning state.
        /// Serialized Name: SpringbootserversProperties.provisioningState
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootServerProperties(int? port, string server, IList<IPAddress> fqdnAndIPAddressList, ResourceIdentifier machineArmId, int? totalApps, int? springBootApps, IList<SpringBootSiteError> errors, SpringAppDiscoveryProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Port = port;
            Server = server;
            FqdnAndIPAddressList = fqdnAndIPAddressList;
            MachineArmId = machineArmId;
            TotalApps = totalApps;
            SpringBootApps = springBootApps;
            Errors = errors;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootServerProperties"/> for deserialization. </summary>
        internal SpringBootServerProperties()
        {
        }

        /// <summary>
        /// Target server port for remote login
        /// Serialized Name: SpringbootserversProperties.port
        /// </summary>
        public int? Port { get; set; }
        /// <summary>
        /// Server is the target server name or ip address to discover of SpringBootServer.
        /// Serialized Name: SpringbootserversProperties.server
        /// </summary>
        public string Server { get; set; }
        /// <summary>
        /// The alternative FQDN or IP addresses to discover for this server
        /// Serialized Name: SpringbootserversProperties.fqdnAndIpAddressList
        /// </summary>
        public IList<IPAddress> FqdnAndIPAddressList { get; }
        /// <summary>
        /// The machine Id from ARM
        /// Serialized Name: SpringbootserversProperties.machineArmId
        /// </summary>
        public ResourceIdentifier MachineArmId { get; set; }
        /// <summary>
        /// The total number of apps been discovered
        /// Serialized Name: SpringbootserversProperties.totalApps
        /// </summary>
        public int? TotalApps { get; set; }
        /// <summary>
        /// The total number of spring boot apps been discovered
        /// Serialized Name: SpringbootserversProperties.springBootApps
        /// </summary>
        public int? SpringBootApps { get; set; }
        /// <summary>
        /// The list of errors.
        /// Serialized Name: SpringbootserversProperties.errors
        /// </summary>
        public IList<SpringBootSiteError> Errors { get; }
        /// <summary>
        /// The resource provisioning state.
        /// Serialized Name: SpringbootserversProperties.provisioningState
        /// </summary>
        public SpringAppDiscoveryProvisioningState? ProvisioningState { get; set; }
    }
}
