// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The springbootservers list resource definition.
    /// Serialized Name: SpringbootserversListResult
    /// </summary>
    internal partial class SpringBootServerList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootServerList"/>. </summary>
        internal SpringBootServerList()
        {
            Value = new ChangeTrackingList<SpringBootServerData>();
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootServerList"/>. </summary>
        /// <param name="value">
        /// The springbootsites list.
        /// Serialized Name: SpringbootserversListResult.value
        /// </param>
        /// <param name="nextLink">
        /// The link used to get the next page of springbootservers resources list.
        /// Serialized Name: SpringbootserversListResult.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootServerList(IReadOnlyList<SpringBootServerData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The springbootsites list.
        /// Serialized Name: SpringbootserversListResult.value
        /// </summary>
        public IReadOnlyList<SpringBootServerData> Value { get; }
        /// <summary>
        /// The link used to get the next page of springbootservers resources list.
        /// Serialized Name: SpringbootserversListResult.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
