// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The springbootapps resource definition.
    /// Serialized Name: SpringbootappsProperties
    /// </summary>
    public partial class SpringBootAppProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootAppProperties"/>. </summary>
        public SpringBootAppProperties()
        {
            ApplicationConfigurations = new ChangeTrackingList<SpringBootAppApplicationConfigurationsItem>();
            BindingPorts = new ChangeTrackingList<int>();
            Certificates = new ChangeTrackingList<string>();
            Dependencies = new ChangeTrackingList<string>();
            Environments = new ChangeTrackingList<string>();
            JvmOptions = new ChangeTrackingList<string>();
            Miscs = new ChangeTrackingList<SpringBootAppMiscsItem>();
            Instances = new ChangeTrackingList<SpringBootAppInstancesItem>();
            Servers = new ChangeTrackingList<string>();
            MachineArmIds = new ChangeTrackingList<ResourceIdentifier>();
            StaticContentLocations = new ChangeTrackingList<string>();
            ConnectionStrings = new ChangeTrackingList<string>();
            Errors = new ChangeTrackingList<SpringBootSiteError>();
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootAppProperties"/>. </summary>
        /// <param name="appName">
        /// The name of SpringBootApp.
        /// Serialized Name: SpringbootappsProperties.appName
        /// </param>
        /// <param name="artifactName">
        /// The artifact name of SpringBootApp.
        /// Serialized Name: SpringbootappsProperties.artifactName
        /// </param>
        /// <param name="appPort">
        /// The application port.
        /// Serialized Name: SpringbootappsProperties.appPort
        /// </param>
        /// <param name="appType">
        /// The application type, whether it is a SpringBoot app.
        /// Serialized Name: SpringbootappsProperties.appType
        /// </param>
        /// <param name="applicationConfigurations">
        /// The application configuration file list.
        /// Serialized Name: SpringbootappsProperties.applicationConfigurations
        /// </param>
        /// <param name="bindingPorts">
        /// The application binding port list.
        /// Serialized Name: SpringbootappsProperties.bindingPorts
        /// </param>
        /// <param name="buildJdkVersion">
        /// The jdk version in build.
        /// Serialized Name: SpringbootappsProperties.buildJdkVersion
        /// </param>
        /// <param name="certificates">
        /// The certificate file list.
        /// Serialized Name: SpringbootappsProperties.certificates
        /// </param>
        /// <param name="checksum">
        /// The checksum of jar file.
        /// Serialized Name: SpringbootappsProperties.checksum
        /// </param>
        /// <param name="dependencies">
        /// The dependency list.
        /// Serialized Name: SpringbootappsProperties.dependencies
        /// </param>
        /// <param name="environments">
        /// The environment variable list.
        /// Serialized Name: SpringbootappsProperties.environments
        /// </param>
        /// <param name="instanceCount">
        /// The total instance count the app deployed.
        /// Serialized Name: SpringbootappsProperties.instanceCount
        /// </param>
        /// <param name="jarFileLocation">
        /// The jar file location on the server.
        /// Serialized Name: SpringbootappsProperties.jarFileLocation
        /// </param>
        /// <param name="jvmMemoryInMB">
        /// The jvm heap memory allocated.
        /// Serialized Name: SpringbootappsProperties.jvmMemoryInMB
        /// </param>
        /// <param name="jvmOptions">
        /// The jvm options.
        /// Serialized Name: SpringbootappsProperties.jvmOptions
        /// </param>
        /// <param name="miscs">
        /// The other types of date collected.
        /// Serialized Name: SpringbootappsProperties.miscs
        /// </param>
        /// <param name="instances">
        /// The breakdown info for app instances on all the servers
        /// Serialized Name: SpringbootappsProperties.instances
        /// </param>
        /// <param name="runtimeJdkVersion">
        /// The jdk version installed on server
        /// Serialized Name: SpringbootappsProperties.runtimeJdkVersion
        /// </param>
        /// <param name="servers">
        /// The server list the app installed
        /// Serialized Name: SpringbootappsProperties.servers
        /// </param>
        /// <param name="machineArmIds">
        /// The machine ARM id list the app belongs to.
        /// Serialized Name: SpringbootappsProperties.machineArmIds
        /// </param>
        /// <param name="siteName">
        /// The site name.
        /// Serialized Name: SpringbootappsProperties.siteName
        /// </param>
        /// <param name="springBootVersion">
        /// The spring boot version.
        /// Serialized Name: SpringbootappsProperties.springBootVersion
        /// </param>
        /// <param name="staticContentLocations">
        /// The static content location list.
        /// Serialized Name: SpringbootappsProperties.staticContentLocations
        /// </param>
        /// <param name="connectionStrings">
        /// The connection string list.
        /// Serialized Name: SpringbootappsProperties.connectionStrings
        /// </param>
        /// <param name="lastModifiedOn">
        /// Time when this springbootapps jar file was last modified.
        /// Serialized Name: SpringbootappsProperties.lastModifiedTime
        /// </param>
        /// <param name="lastUpdatedOn">
        /// Time when this springbootapps instance was last refreshed.
        /// Serialized Name: SpringbootappsProperties.lastUpdatedTime
        /// </param>
        /// <param name="provisioningState">
        /// The resource provisioning state.
        /// Serialized Name: SpringbootappsProperties.provisioningState
        /// </param>
        /// <param name="errors">
        /// The list of errors.
        /// Serialized Name: SpringbootappsProperties.errors
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootAppProperties(string appName, string artifactName, int? appPort, string appType, IList<SpringBootAppApplicationConfigurationsItem> applicationConfigurations, IList<int> bindingPorts, string buildJdkVersion, IList<string> certificates, string checksum, IList<string> dependencies, IList<string> environments, int? instanceCount, string jarFileLocation, int? jvmMemoryInMB, IList<string> jvmOptions, IList<SpringBootAppMiscsItem> miscs, IList<SpringBootAppInstancesItem> instances, string runtimeJdkVersion, IList<string> servers, IList<ResourceIdentifier> machineArmIds, string siteName, string springBootVersion, IList<string> staticContentLocations, IList<string> connectionStrings, DateTimeOffset? lastModifiedOn, DateTimeOffset? lastUpdatedOn, SpringAppDiscoveryProvisioningState? provisioningState, IList<SpringBootSiteError> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AppName = appName;
            ArtifactName = artifactName;
            AppPort = appPort;
            AppType = appType;
            ApplicationConfigurations = applicationConfigurations;
            BindingPorts = bindingPorts;
            BuildJdkVersion = buildJdkVersion;
            Certificates = certificates;
            Checksum = checksum;
            Dependencies = dependencies;
            Environments = environments;
            InstanceCount = instanceCount;
            JarFileLocation = jarFileLocation;
            JvmMemoryInMB = jvmMemoryInMB;
            JvmOptions = jvmOptions;
            Miscs = miscs;
            Instances = instances;
            RuntimeJdkVersion = runtimeJdkVersion;
            Servers = servers;
            MachineArmIds = machineArmIds;
            SiteName = siteName;
            SpringBootVersion = springBootVersion;
            StaticContentLocations = staticContentLocations;
            ConnectionStrings = connectionStrings;
            LastModifiedOn = lastModifiedOn;
            LastUpdatedOn = lastUpdatedOn;
            ProvisioningState = provisioningState;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The name of SpringBootApp.
        /// Serialized Name: SpringbootappsProperties.appName
        /// </summary>
        public string AppName { get; set; }
        /// <summary>
        /// The artifact name of SpringBootApp.
        /// Serialized Name: SpringbootappsProperties.artifactName
        /// </summary>
        public string ArtifactName { get; set; }
        /// <summary>
        /// The application port.
        /// Serialized Name: SpringbootappsProperties.appPort
        /// </summary>
        public int? AppPort { get; set; }
        /// <summary>
        /// The application type, whether it is a SpringBoot app.
        /// Serialized Name: SpringbootappsProperties.appType
        /// </summary>
        public string AppType { get; set; }
        /// <summary>
        /// The application configuration file list.
        /// Serialized Name: SpringbootappsProperties.applicationConfigurations
        /// </summary>
        public IList<SpringBootAppApplicationConfigurationsItem> ApplicationConfigurations { get; }
        /// <summary>
        /// The application binding port list.
        /// Serialized Name: SpringbootappsProperties.bindingPorts
        /// </summary>
        public IList<int> BindingPorts { get; }
        /// <summary>
        /// The jdk version in build.
        /// Serialized Name: SpringbootappsProperties.buildJdkVersion
        /// </summary>
        public string BuildJdkVersion { get; set; }
        /// <summary>
        /// The certificate file list.
        /// Serialized Name: SpringbootappsProperties.certificates
        /// </summary>
        public IList<string> Certificates { get; }
        /// <summary>
        /// The checksum of jar file.
        /// Serialized Name: SpringbootappsProperties.checksum
        /// </summary>
        public string Checksum { get; set; }
        /// <summary>
        /// The dependency list.
        /// Serialized Name: SpringbootappsProperties.dependencies
        /// </summary>
        public IList<string> Dependencies { get; }
        /// <summary>
        /// The environment variable list.
        /// Serialized Name: SpringbootappsProperties.environments
        /// </summary>
        public IList<string> Environments { get; }
        /// <summary>
        /// The total instance count the app deployed.
        /// Serialized Name: SpringbootappsProperties.instanceCount
        /// </summary>
        public int? InstanceCount { get; set; }
        /// <summary>
        /// The jar file location on the server.
        /// Serialized Name: SpringbootappsProperties.jarFileLocation
        /// </summary>
        public string JarFileLocation { get; set; }
        /// <summary>
        /// The jvm heap memory allocated.
        /// Serialized Name: SpringbootappsProperties.jvmMemoryInMB
        /// </summary>
        public int? JvmMemoryInMB { get; set; }
        /// <summary>
        /// The jvm options.
        /// Serialized Name: SpringbootappsProperties.jvmOptions
        /// </summary>
        public IList<string> JvmOptions { get; }
        /// <summary>
        /// The other types of date collected.
        /// Serialized Name: SpringbootappsProperties.miscs
        /// </summary>
        public IList<SpringBootAppMiscsItem> Miscs { get; }
        /// <summary>
        /// The breakdown info for app instances on all the servers
        /// Serialized Name: SpringbootappsProperties.instances
        /// </summary>
        public IList<SpringBootAppInstancesItem> Instances { get; }
        /// <summary>
        /// The jdk version installed on server
        /// Serialized Name: SpringbootappsProperties.runtimeJdkVersion
        /// </summary>
        public string RuntimeJdkVersion { get; set; }
        /// <summary>
        /// The server list the app installed
        /// Serialized Name: SpringbootappsProperties.servers
        /// </summary>
        public IList<string> Servers { get; }
        /// <summary>
        /// The machine ARM id list the app belongs to.
        /// Serialized Name: SpringbootappsProperties.machineArmIds
        /// </summary>
        public IList<ResourceIdentifier> MachineArmIds { get; }
        /// <summary>
        /// The site name.
        /// Serialized Name: SpringbootappsProperties.siteName
        /// </summary>
        public string SiteName { get; set; }
        /// <summary>
        /// The spring boot version.
        /// Serialized Name: SpringbootappsProperties.springBootVersion
        /// </summary>
        public string SpringBootVersion { get; set; }
        /// <summary>
        /// The static content location list.
        /// Serialized Name: SpringbootappsProperties.staticContentLocations
        /// </summary>
        public IList<string> StaticContentLocations { get; }
        /// <summary>
        /// The connection string list.
        /// Serialized Name: SpringbootappsProperties.connectionStrings
        /// </summary>
        public IList<string> ConnectionStrings { get; }
        /// <summary>
        /// Time when this springbootapps jar file was last modified.
        /// Serialized Name: SpringbootappsProperties.lastModifiedTime
        /// </summary>
        public DateTimeOffset? LastModifiedOn { get; set; }
        /// <summary>
        /// Time when this springbootapps instance was last refreshed.
        /// Serialized Name: SpringbootappsProperties.lastUpdatedTime
        /// </summary>
        public DateTimeOffset? LastUpdatedOn { get; set; }
        /// <summary>
        /// The resource provisioning state.
        /// Serialized Name: SpringbootappsProperties.provisioningState
        /// </summary>
        public SpringAppDiscoveryProvisioningState? ProvisioningState { get; set; }
        /// <summary>
        /// The list of errors.
        /// Serialized Name: SpringbootappsProperties.errors
        /// </summary>
        public IList<SpringBootSiteError> Errors { get; }
    }
}
