// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The springbootapps list resource definition.
    /// Serialized Name: SpringbootappsListResult
    /// </summary>
    internal partial class SpringBootAppList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SpringBootAppList"/>. </summary>
        internal SpringBootAppList()
        {
            Value = new ChangeTrackingList<SpringBootAppData>();
        }

        /// <summary> Initializes a new instance of <see cref="SpringBootAppList"/>. </summary>
        /// <param name="value">
        /// The springbootsites list.
        /// Serialized Name: SpringbootappsListResult.value
        /// </param>
        /// <param name="nextLink">
        /// The link used to get the next page of springbootapps resources list.
        /// Serialized Name: SpringbootappsListResult.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SpringBootAppList(IReadOnlyList<SpringBootAppData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The springbootsites list.
        /// Serialized Name: SpringbootappsListResult.value
        /// </summary>
        public IReadOnlyList<SpringBootAppData> Value { get; }
        /// <summary>
        /// The link used to get the next page of springbootapps resources list.
        /// Serialized Name: SpringbootappsListResult.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
