// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary>
    /// The resource provisioning state.
    /// Serialized Name: ProvisioningState
    /// </summary>
    public readonly partial struct SpringAppDiscoveryProvisioningState : IEquatable<SpringAppDiscoveryProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SpringAppDiscoveryProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SpringAppDiscoveryProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";
        private const string DeletingValue = "Deleting";

        /// <summary>
        /// Unknown
        /// Serialized Name: ProvisioningState.Unknown
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Unknown { get; } = new SpringAppDiscoveryProvisioningState(UnknownValue);
        /// <summary>
        /// Succeeded
        /// Serialized Name: ProvisioningState.Succeeded
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Succeeded { get; } = new SpringAppDiscoveryProvisioningState(SucceededValue);
        /// <summary>
        /// Failed
        /// Serialized Name: ProvisioningState.Failed
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Failed { get; } = new SpringAppDiscoveryProvisioningState(FailedValue);
        /// <summary>
        /// Canceled
        /// Serialized Name: ProvisioningState.Canceled
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Canceled { get; } = new SpringAppDiscoveryProvisioningState(CanceledValue);
        /// <summary>
        /// Accepted
        /// Serialized Name: ProvisioningState.Accepted
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Accepted { get; } = new SpringAppDiscoveryProvisioningState(AcceptedValue);
        /// <summary>
        /// Provisioning
        /// Serialized Name: ProvisioningState.Provisioning
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Provisioning { get; } = new SpringAppDiscoveryProvisioningState(ProvisioningValue);
        /// <summary>
        /// Deleting
        /// Serialized Name: ProvisioningState.Deleting
        /// </summary>
        public static SpringAppDiscoveryProvisioningState Deleting { get; } = new SpringAppDiscoveryProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="SpringAppDiscoveryProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SpringAppDiscoveryProvisioningState left, SpringAppDiscoveryProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SpringAppDiscoveryProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SpringAppDiscoveryProvisioningState left, SpringAppDiscoveryProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SpringAppDiscoveryProvisioningState"/>. </summary>
        public static implicit operator SpringAppDiscoveryProvisioningState(string value) => new SpringAppDiscoveryProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SpringAppDiscoveryProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SpringAppDiscoveryProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
