// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    internal class SpringBootSiteOperationSource : IOperationSource<SpringBootSiteResource>
    {
        private readonly ArmClient _client;

        internal SpringBootSiteOperationSource(ArmClient client)
        {
            _client = client;
        }

        SpringBootSiteResource IOperationSource<SpringBootSiteResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SpringBootSiteData.DeserializeSpringBootSiteData(document.RootElement);
            return new SpringBootSiteResource(_client, data);
        }

        async ValueTask<SpringBootSiteResource> IOperationSource<SpringBootSiteResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SpringBootSiteData.DeserializeSpringBootSiteData(document.RootElement);
            return new SpringBootSiteResource(_client, data);
        }
    }
}
