// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    internal class SpringBootServerOperationSource : IOperationSource<SpringBootServerResource>
    {
        private readonly ArmClient _client;

        internal SpringBootServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        SpringBootServerResource IOperationSource<SpringBootServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SpringBootServerData.DeserializeSpringBootServerData(document.RootElement);
            return new SpringBootServerResource(_client, data);
        }

        async ValueTask<SpringBootServerResource> IOperationSource<SpringBootServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SpringBootServerData.DeserializeSpringBootServerData(document.RootElement);
            return new SpringBootServerResource(_client, data);
        }
    }
}
