// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    internal class SpringBootAppOperationSource : IOperationSource<SpringBootAppResource>
    {
        private readonly ArmClient _client;

        internal SpringBootAppOperationSource(ArmClient client)
        {
            _client = client;
        }

        SpringBootAppResource IOperationSource<SpringBootAppResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SpringBootAppData.DeserializeSpringBootAppData(document.RootElement);
            return new SpringBootAppResource(_client, data);
        }

        async ValueTask<SpringBootAppResource> IOperationSource<SpringBootAppResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SpringBootAppData.DeserializeSpringBootAppData(document.RootElement);
            return new SpringBootAppResource(_client, data);
        }
    }
}
