// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SpringAppDiscovery.Mocking;

namespace Azure.ResourceManager.SpringAppDiscovery
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.SpringAppDiscovery. </summary>
    public static partial class SpringAppDiscoveryExtensions
    {
        private static MockableSpringAppDiscoveryArmClient GetMockableSpringAppDiscoveryArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableSpringAppDiscoveryArmClient(client0));
        }

        private static MockableSpringAppDiscoveryResourceGroupResource GetMockableSpringAppDiscoveryResourceGroupResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableSpringAppDiscoveryResourceGroupResource(client, resource.Id));
        }

        private static MockableSpringAppDiscoverySubscriptionResource GetMockableSpringAppDiscoverySubscriptionResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableSpringAppDiscoverySubscriptionResource(client, resource.Id));
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryArmClient.GetSpringBootSiteResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SpringBootSiteResource"/> object. </returns>
        public static SpringBootSiteResource GetSpringBootSiteResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableSpringAppDiscoveryArmClient(client).GetSpringBootSiteResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootServerResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootServerResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootServerResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryArmClient.GetSpringBootServerResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SpringBootServerResource"/> object. </returns>
        public static SpringBootServerResource GetSpringBootServerResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableSpringAppDiscoveryArmClient(client).GetSpringBootServerResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootAppResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootAppResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootAppResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryArmClient.GetSpringBootAppResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SpringBootAppResource"/> object. </returns>
        public static SpringBootAppResource GetSpringBootAppResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableSpringAppDiscoveryArmClient(client).GetSpringBootAppResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteSummaryResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteSummaryResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteSummaryResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryArmClient.GetSpringBootSiteSummaryResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SpringBootSiteSummaryResource"/> object. </returns>
        public static SpringBootSiteSummaryResource GetSpringBootSiteSummaryResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableSpringAppDiscoveryArmClient(client).GetSpringBootSiteSummaryResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteErrorSummaryResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteErrorSummaryResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteErrorSummaryResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryArmClient.GetSpringBootSiteErrorSummaryResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SpringBootSiteErrorSummaryResource"/> object. </returns>
        public static SpringBootSiteErrorSummaryResource GetSpringBootSiteErrorSummaryResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableSpringAppDiscoveryArmClient(client).GetSpringBootSiteErrorSummaryResource(id);
        }

        /// <summary>
        /// Gets a collection of SpringBootSiteResources in the ResourceGroupResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryResourceGroupResource.GetSpringBootSites()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> is null. </exception>
        /// <returns> An object representing collection of SpringBootSiteResources and their operations over a SpringBootSiteResource. </returns>
        public static SpringBootSiteCollection GetSpringBootSites(this ResourceGroupResource resourceGroupResource)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableSpringAppDiscoveryResourceGroupResource(resourceGroupResource).GetSpringBootSites();
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryResourceGroupResource.GetSpringBootSiteAsync(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="springbootsitesName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<SpringBootSiteResource>> GetSpringBootSiteAsync(this ResourceGroupResource resourceGroupResource, string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return await GetMockableSpringAppDiscoveryResourceGroupResource(resourceGroupResource).GetSpringBootSiteAsync(springbootsitesName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoveryResourceGroupResource.GetSpringBootSite(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="springbootsitesName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<SpringBootSiteResource> GetSpringBootSite(this ResourceGroupResource resourceGroupResource, string springbootsitesName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableSpringAppDiscoveryResourceGroupResource(resourceGroupResource).GetSpringBootSite(springbootsitesName, cancellationToken);
        }

        /// <summary>
        /// List springbootsites resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootSites(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An async collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<SpringBootSiteResource> GetSpringBootSitesAsync(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootSitesAsync(cancellationToken);
        }

        /// <summary>
        /// List springbootsites resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootSites(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> A collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<SpringBootSiteResource> GetSpringBootSites(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootSites(cancellationToken);
        }

        /// <summary>
        /// List springbootservers resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootservers_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootServerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootServers(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="siteName"/> is null. </exception>
        /// <returns> An async collection of <see cref="SpringBootServerResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<SpringBootServerResource> GetSpringBootServersAsync(this SubscriptionResource subscriptionResource, string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootServersAsync(siteName, cancellationToken);
        }

        /// <summary>
        /// List springbootservers resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootservers_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootServerResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootServers(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="siteName"/> is null. </exception>
        /// <returns> A collection of <see cref="SpringBootServerResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<SpringBootServerResource> GetSpringBootServers(this SubscriptionResource subscriptionResource, string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootServers(siteName, cancellationToken);
        }

        /// <summary>
        /// List springbootapps resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootApps(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="siteName"/> is null. </exception>
        /// <returns> An async collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<SpringBootAppResource> GetSpringBootAppsAsync(this SubscriptionResource subscriptionResource, string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootAppsAsync(siteName, cancellationToken);
        }

        /// <summary>
        /// List springbootapps resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableSpringAppDiscoverySubscriptionResource.GetSpringBootApps(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="siteName"/> is null. </exception>
        /// <returns> A collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<SpringBootAppResource> GetSpringBootApps(this SubscriptionResource subscriptionResource, string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableSpringAppDiscoverySubscriptionResource(subscriptionResource).GetSpringBootApps(siteName, cancellationToken);
        }
    }
}
